/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.client;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;

/**
 * provider class for client.
 *
 * @author vinay@ainosoft.com
 * @version $Id: $Id
 */
public class ClientProvider implements Provider<Client> {

  @Inject
  HttpServletRequest httpServletRequest;

  @Inject
  Injector injector;

  /** {@inheritDoc} */
  @Override
  public Client get() {
    return getClient();
  }

  /**
   * <p>
   * getClient.
   * </p>
   *
   * @return a {@link org.appops.service.client.Client} object.
   */
  public Client getClient() {
    return instantiateClient();
  }

  private Client instantiateClient() {

    String browserDetails = httpServletRequest.getHeader("User-Agent");
    String userAgent = browserDetails;
    String user = userAgent.toLowerCase();

    String os = "";
    String browser = "";


    if (userAgent.toLowerCase().indexOf("windows") >= 0) {
      os = "Windows";
    } else if (userAgent.toLowerCase().indexOf("mac") >= 0) {
      os = "Mac";
    } else if (userAgent.toLowerCase().indexOf("x11") >= 0) {
      os = "Linux";
    } else if (userAgent.toLowerCase().indexOf("android") >= 0) {
      os = "Android";
    } else if (userAgent.toLowerCase().indexOf("iphone") >= 0) {
      os = "IPhone";
    } else {
      os = "UnKnown";
    }

    if (user.contains("msie")) {
      String substring = userAgent.substring(userAgent.indexOf("MSIE")).split(";")[0];
      browser = substring.split(" ")[0].replace("MSIE", "IE") + "-" + substring.split(" ")[1];
    } else if (user.contains("safari") && user.contains("version")) {
      browser = (userAgent.substring(userAgent.indexOf("Safari")).split(" ")[0]).split("/")[0] + "-"
          + (userAgent.substring(userAgent.indexOf("Version")).split(" ")[0]).split("/")[1];
    } else if (user.contains("opr") || user.contains("opera")) {
      if (user.contains("opera")) {
        browser = (userAgent.substring(userAgent.indexOf("Opera")).split(" ")[0]).split("/")[0]
            + "-" + (userAgent.substring(userAgent.indexOf("Version")).split(" ")[0]).split("/")[1];
      } else if (user.contains("opr")) {
        browser = ((userAgent.substring(userAgent.indexOf("OPR")).split(" ")[0]).replace("/", "-"))
            .replace("OPR", "Opera");
      }
    } else if (user.contains("chrome")) {
      browser = (userAgent.substring(userAgent.indexOf("Chrome")).split(" ")[0]).replace("/", "-");
    } else if ((user.indexOf("mozilla/7.0") > -1) || (user.indexOf("netscape6") != -1)
        || (user.indexOf("mozilla/4.7") != -1) || (user.indexOf("mozilla/4.78") != -1)
        || (user.indexOf("mozilla/4.08") != -1) || (user.indexOf("mozilla/3") != -1)) {
      browser = "Netscape-?";
    } else if (user.contains("firefox")) {
      browser = (userAgent.substring(userAgent.indexOf("Firefox")).split(" ")[0]).replace("/", "-");
    } else if (user.contains("rv")) {
      browser = "IE-" + user.substring(user.indexOf("rv") + 3, user.indexOf(")"));
    } else {
      browser = "UnKnown";
    }

    if ((os.equals("Android") || os.equals("IPhone") || os.equals("UnKnown"))
        && browser.equals("UnKnown")) {
      ApiClient client = injector.getInstance(ApiClient.class);
      client.setOs(os);
      return client;
    } else {
      WebClient client = injector.getInstance(WebClient.class);
      client.setOs(os);
      client.setBrowserName(browser);
      return client;
    }

  }


}
