/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.service.slim.builder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.appops.core.annotation.Config;
import org.appops.core.deployment.DeploymentMode;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.slim.base.invocation.ApiProxyInvocationHandler;

/**
 * Build class which creates the Service slim object with header information.
 *
 */
public class ServiceSlimInvocationBuilder {

  private Class<?> apiClass;
  private HashMap<String, String> headerMap;
  private ServiceConfiguration serviceConfiguration;
  @Inject
  private Injector injector;
  @Inject
  private ApiProxyInvocationHandler proxyInvocationHandler;

  public ServiceSlimInvocationBuilder() {
    headerMap = new HashMap<String, String>();
  }

  public ServiceSlimInvocationBuilder getServiceInstance(Class<?> apiClass) {
    this.apiClass = apiClass;
    return this;
  }


  public ServiceSlimInvocationBuilder addHeader(String key, String value) {
    headerMap.put(key, value);
    return this;
  }


  public <T> Object build() {
    DeploymentMode deploymentMode = getServiceConfiguration().getMode();
    if (deploymentMode.equals(DeploymentMode.STANDALONE)) {
      proxyInvocationHandler.getApiRestInvoker().getHttpHeader().getHeaderMap().putAll(headerMap);
      return createProxyForApiClass(apiClass);
    } else if (deploymentMode.equals(DeploymentMode.CLUBBED)) {
      return injector.getInstance(apiClass);
    }
    return null;
  }


  public <T> Object createProxyForApiClass(Class<T> apiClass) {

    return Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[] {apiClass},
        proxyInvocationHandler);

  }

  public ServiceConfiguration getServiceConfiguration() {
    return serviceConfiguration;
  }

  @Inject
  public void setServiceConfiguration(@Config ServiceConfiguration serviceConfiguration) {
    this.serviceConfiguration = serviceConfiguration;
  }



}
