/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.generator;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.appops.configuration.generator.ConfigJsonGenerator;
import org.appops.configuration.guice.ConfigServiceModule;
import org.appops.marshaller.guice.MarshallerModule;

public class ConfigGenerator {
    public static void main(String[] args) throws IOException {
        if (args.length <= 0) {
            System.out.println("Please provide configuration file...!!!");
            return;
        }
        String configFile = args[0];
        Injector injector = Guice.createInjector(new ConfigServiceModule(), new MarshallerModule());
        String json = injector.getInstance(ConfigJsonGenerator.class).generateConfiguration();
        FileUtils.writeStringToFile(new File(configFile), json, StandardCharsets.UTF_8);
    }
}

