/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.guice;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.appops.configuration.generator.ConfigWrapper;
import org.appops.configuration.provider.ConfigurationProvider;
import org.appops.core.annotation.Config;
import org.appops.marshaller.Marshaller;

public class ConfigProvisionInterceptor
implements MethodInterceptor {
    private ConfigurationProvider configurationProvider;
    private Marshaller marshaller;

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        Parameter[] parameters = m.getParameters();
        Object[] args = invocation.getArguments();
        for (int i = 0; i < parameters.length; ++i) {
            ConfigWrapper configWrapper;
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(Config.class) || (configWrapper = this.configurationProvider.getConfigWrapper(parameter.getType().getCanonicalName())) == null || configWrapper.getConfig() == null || configWrapper.getConfig().isEmpty()) continue;
            Object paramValue = this.getMarshaller().unmarshall(configWrapper.getConfig(), parameter.getType(), configWrapper.getDescriptorType());
            args[i] = paramValue;
        }
        return invocation.proceed();
    }

    @Inject
    public void setCustomProvisionListener(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

