/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.slimimpl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Module;
import java.util.Set;
import org.appops.configuration.slimimpl.SlimImplStructure;
import org.appops.core.constant.ConfigType;

public class SlimImplConfigTable {
    private Table<String, ConfigType, SlimImplStructure> configTable = HashBasedTable.create();

    public SlimImplStructure getConfigurationTable(String serviceName, ConfigType type) {
        if (this.configTable.row(serviceName) != null && this.configTable.row(serviceName).get((Object)type) != null) {
            return this.configTable.row(serviceName).get((Object)type);
        }
        return null;
    }

    public Table<String, ConfigType, SlimImplStructure> getConfigTable() {
        return this.configTable;
    }

    public void addModuleConfig(String serviceName, ConfigType type, Set<Class<? extends Module>> modules) {
        if (ConfigType.SLIM == type) {
            this.addSlimModules(serviceName, modules);
        } else if (ConfigType.IMPL == type) {
            this.addImplModules(serviceName, modules);
        }
    }

    public void addSlimModules(String serviceName, Set<Class<? extends Module>> modules) {
        if (this.getConfigurationTable(serviceName, ConfigType.SLIM) != null) {
            this.getConfigurationTable(serviceName, ConfigType.SLIM).setModules(modules);
        } else {
            SlimImplStructure structure = new SlimImplStructure();
            structure.setModules(modules);
            this.configTable.put(serviceName, ConfigType.SLIM, structure);
        }
    }

    public void addImplModules(String serviceName, Set<Class<? extends Module>> modules) {
        if (this.getConfigurationTable(serviceName, ConfigType.IMPL) != null) {
            this.getConfigurationTable(serviceName, ConfigType.IMPL).setModules(modules);
        } else {
            SlimImplStructure structure = new SlimImplStructure();
            structure.setModules(modules);
            this.configTable.put(serviceName, ConfigType.IMPL, structure);
        }
    }

    public void addConfiguration(String serviceName, ConfigType configType, String canonicalName, String configuration) {
        if (this.getConfigurationTable(serviceName, configType) != null) {
            this.getConfigurationTable(serviceName, configType).getConfig().put(canonicalName, configuration);
        } else {
            SlimImplStructure structure = new SlimImplStructure();
            structure.getConfig().put(canonicalName, configuration);
            this.configTable.put(serviceName, configType, structure);
        }
    }
}

