/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.destination;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LoggingException;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.LogFilter;
import org.appops.logging.logger.config.constant.FilterProperty;
import org.appops.logging.logger.config.constant.FilterType;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.LoggerType;
import org.slf4j.LoggerFactory;

public class LogbackLogger
extends DestinationLogger<Logger> {
    private LoggerContext loggerContext;
    private Logger internalLogger;

    @Override
    public boolean log(org.appops.logging.meta.Level level, String message) {
        Level actuallevel = level == null ? this.convertLevel(null) : this.convertLevel(level.name());
        this.internalLogger().log(null, null, actuallevel.toInt() / 1000, message, null, null);
        return true;
    }

    @Override
    public LoggerType type() {
        return LoggerType.LOGBACK;
    }

    @Override
    public void removeAllHandlers() {
        this.internalLogger().detachAndStopAllAppenders();
    }

    @Override
    public void addHandlers(List<HandlerConfig> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            throw new LoggingException("Please provide valid log handlers.");
        }
        for (HandlerConfig handler : handlers) {
            this.addHandler(handler);
        }
    }

    @Override
    public void addHandler(HandlerConfig handler) {
        if (handler == null) {
            throw new LoggingException("Please provide valid log handlers.");
        }
        if (handler.enabled()) {
            switch (handler.name()) {
                case CONSOLE: {
                    this.addConsoleAppender(handler);
                    break;
                }
                case FILE: {
                    this.addFileAppender(handler);
                    break;
                }
                default: {
                    throw new LoggingException("Please provide valid log handler.");
                }
            }
        }
    }

    private LoggerContext getLoggerContext() {
        if (this.loggerContext == null) {
            this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        }
        return this.loggerContext;
    }

    @Override
    protected Logger internalLogger() {
        if (this.internalLogger == null) {
            this.internalLogger = this.getLoggerContext().getLogger("ROOT");
        }
        return this.internalLogger;
    }

    private void addConsoleAppender(HandlerConfig handlerConfig) {
        Map<HandlerAttribute, Object> config = handlerConfig.getConfig();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        String pattern = "%date %level [%thread] %logger{10} [%file:%line] %msg%n";
        if (config.get((Object)HandlerAttribute.PATTERN) != null) {
            pattern = this.formatPattern(config.get((Object)HandlerAttribute.PATTERN).toString());
        }
        ple.setPattern(pattern);
        ple.setContext(this.getLoggerContext());
        ple.start();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setContext(this.getLoggerContext());
        consoleAppender.setName(handlerConfig.name().name());
        consoleAppender.setEncoder(ple);
        this.addFilters(consoleAppender, handlerConfig.getFilters());
        consoleAppender.start();
        Level level = config.get((Object)HandlerAttribute.LEVEL) != null ? this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString()) : Level.ALL;
        this.internalLogger().setLevel(level);
        this.internalLogger().addAppender((Appender<ILoggingEvent>)consoleAppender);
    }

    private void addFileAppender(HandlerConfig logHandler) {
        Map<HandlerAttribute, Object> config = logHandler.getConfig();
        String filename = config.get((Object)HandlerAttribute.FILENAME) != null ? config.get((Object)HandlerAttribute.FILENAME).toString() : "logback.log";
        RollingFileAppender<ILoggingEvent> logFileAppender = new RollingFileAppender<ILoggingEvent>();
        logFileAppender.setContext(this.getLoggerContext());
        logFileAppender.setName(logHandler.name().name());
        logFileAppender.setAppend(true);
        logFileAppender.setFile(filename);
        PatternLayoutEncoder patternEncoder = this.getPatternEncoder(config.get((Object)HandlerAttribute.PATTERN));
        TimeBasedRollingPolicy<ILoggingEvent> rollingPolicy = this.getTimeBasedPolicy(logFileAppender, filename, config.get((Object)HandlerAttribute.MAX_BACKUP_INDEX));
        SizeBasedTriggeringPolicy<ILoggingEvent> sizeBasedTriggeringPolicy = this.getSizeBasedPolicy(config.get((Object)HandlerAttribute.MAXSIZE));
        logFileAppender.setEncoder(patternEncoder);
        logFileAppender.setRollingPolicy(rollingPolicy);
        logFileAppender.setTriggeringPolicy(sizeBasedTriggeringPolicy);
        this.addFilters(logFileAppender, logHandler.getFilters());
        logFileAppender.start();
        Level logbackLevel = config.get((Object)HandlerAttribute.LEVEL) != null ? this.convertLevel(config.get((Object)HandlerAttribute.LEVEL).toString()) : Level.ALL;
        this.internalLogger().setLevel(logbackLevel);
        this.internalLogger().addAppender((Appender<ILoggingEvent>)logFileAppender);
    }

    private SizeBasedTriggeringPolicy<ILoggingEvent> getSizeBasedPolicy(Object maxSize) {
        SizeBasedTriggeringPolicy<ILoggingEvent> sizeBasedPolicy = new SizeBasedTriggeringPolicy<ILoggingEvent>();
        sizeBasedPolicy.setContext(this.getLoggerContext());
        if (maxSize != null) {
            sizeBasedPolicy.setMaxFileSize(maxSize.toString());
        }
        sizeBasedPolicy.start();
        return sizeBasedPolicy;
    }

    private TimeBasedRollingPolicy<ILoggingEvent> getTimeBasedPolicy(RollingFileAppender<ILoggingEvent> logFileAppender, String filename, Object maxBackupIndex) {
        TimeBasedRollingPolicy<ILoggingEvent> timeBasedPolicy = new TimeBasedRollingPolicy<ILoggingEvent>();
        timeBasedPolicy.setFileNamePattern("%d." + filename);
        timeBasedPolicy.setMaxHistory(3);
        timeBasedPolicy.setParent(logFileAppender);
        timeBasedPolicy.setContext(this.getLoggerContext());
        timeBasedPolicy.start();
        return timeBasedPolicy;
    }

    private PatternLayoutEncoder getPatternEncoder(Object pattern) {
        String defaultPattern = "%date %level [%thread] %logger{10} [%file:%line] %msg%n";
        if (pattern != null) {
            defaultPattern = this.formatPattern(pattern.toString());
        }
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(defaultPattern);
        ple.setContext(this.getLoggerContext());
        ple.start();
        return ple;
    }

    private Level convertLevel(String level) {
        if (org.appops.logging.meta.Level.WARN.name().equals(level) || org.appops.logging.meta.Level.WARNING.name().equals(level)) {
            return Level.WARN;
        }
        if (org.appops.logging.meta.Level.ERROR.name().equals(level)) {
            return Level.ERROR;
        }
        if (org.appops.logging.meta.Level.ALL.name().equals(level)) {
            return Level.TRACE;
        }
        if (org.appops.logging.meta.Level.INFO.name().equals(level)) {
            return Level.INFO;
        }
        if (org.appops.logging.meta.Level.OFF.name().equals(level)) {
            return Level.OFF;
        }
        return Level.INFO;
    }

    @Override
    protected String formatPattern(String pattern) {
        if ((pattern = pattern.trim().replaceAll(" +", " ")).contains("%d") && !pattern.contains("%d{")) {
            pattern = pattern.replaceAll("%d", "%d{yyyy-MM-dd HH:mm:ss}");
        }
        pattern = pattern.replaceAll("%yyyy", "yyyy");
        pattern = pattern.replaceAll("%MMMM", "MMMM");
        pattern = pattern.replaceAll("%MMM", "MMM");
        pattern = pattern.replaceAll("%MM", "MM");
        pattern = pattern.replaceAll("%dd", "dd");
        pattern = pattern.replaceAll("%HH", "HH");
        pattern = pattern.replaceAll("%hh", "hh");
        pattern = pattern.replaceAll("%mm", "mm");
        pattern = pattern.replaceAll("%ss", "ss");
        return pattern;
    }

    private void addFilters(Appender<ILoggingEvent> appender, ArrayList<LogFilter> filters) {
        try {
            for (LogFilter filterConfig : filters) {
                if (!FilterType.RegEx.equals((Object)filterConfig.getName())) continue;
                appender.addFilter(this.addLogFilter(filterConfig));
            }
        }
        catch (Exception e) {
            throw new LoggingException("Exception Occured while adding filter to ::" + this.getClass().getCanonicalName() + e);
        }
    }

    private Filter<ILoggingEvent> addLogFilter(final LogFilter config) {
        return new Filter<ILoggingEvent>(){

            @Override
            public FilterReply decide(ILoggingEvent event) {
                if (config != null) {
                    if (FilterProperty.LOGGER_NAME.equals((Object)config.getApplyOn()) && event.getLoggerName().matches(config.getExpression())) {
                        return LogbackLogger.this.onMatch(config.getOnMatch());
                    }
                    if (FilterProperty.MESSAGE.equals((Object)config.getApplyOn()) && event.getMessage().toString().matches(config.getExpression())) {
                        return LogbackLogger.this.onMatch(config.getOnMatch());
                    }
                }
                return LogbackLogger.this.onMismatch(config.getOnMatch());
            }
        };
    }

    private FilterReply onMatch(org.appops.logging.logger.config.constant.FilterReply onMatch) {
        return this.convertFilterReply(onMatch, false);
    }

    private FilterReply onMismatch(org.appops.logging.logger.config.constant.FilterReply onMatch) {
        return this.convertFilterReply(onMatch, true);
    }

    private FilterReply convertFilterReply(org.appops.logging.logger.config.constant.FilterReply onMatch, boolean invert) {
        switch (onMatch) {
            case ACCEPT: {
                return invert ? FilterReply.DENY : FilterReply.ACCEPT;
            }
            case DENY: {
                return invert ? FilterReply.ACCEPT : FilterReply.DENY;
            }
        }
        return FilterReply.NEUTRAL;
    }
}

