/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.appops.core.annotation.Config;
import org.appops.logging.destination.DestinationLogger;
import org.appops.logging.logger.Logger;
import org.appops.logging.logger.config.LoggerConfig;
import org.appops.logging.logger.store.LogStore;
import org.appops.logging.meta.Level;
import org.appops.logging.meta.LogMeta;

public class LoggerImpl
implements Logger {
    private LogMeta meta;
    private Provider<DestinationLogger> destinationLogger;
    private LoggerConfig config;
    private LogStore logStore;
    public String loggerClassName;

    @Override
    public Logger withLevel(Level level) {
        this.getMeta().addAttribute((String)LogMeta.LEVEL.value(), (Object)level);
        return this;
    }

    public boolean isEnabled(Level level) {
        Level enabledLevel = this.getConfig().getLevel();
        return !Level.OFF.equals((Object)enabledLevel);
    }

    @Override
    public Logger withMessage(String message) {
        this.getMeta().addAttribute((String)LogMeta.MESSAGE.value(), message);
        return this;
    }

    @Override
    public Logger withMeta(LogMeta meta) {
        this.setMeta(meta);
        return this;
    }

    @Override
    public Logger withMeta(String key, Object value) {
        this.getMeta().addAttribute(key, value);
        return this;
    }

    @Override
    public boolean log() {
        Level level = (Level)((Object)this.getMeta().getAttributeValue((String)LogMeta.LEVEL.value()));
        String message = (String)this.getMeta().getAttributeValue((String)LogMeta.MESSAGE.value());
        this.getLogStore().addLogRecord(this.getMeta());
        this.setMeta(null);
        return this.getDestinationLogger().log(level, message);
    }

    public LogMeta getMeta() {
        if (this.meta == null) {
            this.meta = new LogMeta();
            if (this.loggerClassName != null) {
                this.meta.addAttribute((String)LogMeta.LOGGERNAME.value(), this.loggerClassName);
            }
        }
        return this.meta;
    }

    public void setMeta(LogMeta meta) {
        this.meta = meta;
    }

    public DestinationLogger getDestinationLogger() {
        return this.destinationLogger.get();
    }

    @Inject
    public void setDestinationLogger(Provider<DestinationLogger> destinationLogger) {
        this.destinationLogger = destinationLogger;
    }

    public LoggerConfig getConfig() {
        return this.config;
    }

    @Inject
    public void setConfig(@Config LoggerConfig config) {
        this.config = config;
    }

    public LogStore getLogStore() {
        return this.logStore;
    }

    @Inject
    public void setLogStore(LogStore logStore) {
        this.logStore = logStore;
    }

    @Override
    public Logger setLoggerName(String loggerName) {
        this.loggerClassName = loggerName;
        return this;
    }
}

