/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class ContentCrypto {
    private static Logger logger = Logger.getLogger(ContentCrypto.class.getCanonicalName());
    private static final String Key = "Foo12345Foo12345";

    public String encrypt(String textToEncrypt) {
        String str = null;
        try {
            SecretKeySpec aesKey = new SecretKeySpec(Key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] encrypted = cipher.doFinal(textToEncrypt.getBytes(StandardCharsets.UTF_8));
            str = Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in encrypt() :: ", e);
        }
        return str;
    }

    public String decrypt(String encrypted) {
        String decrypted = null;
        try {
            byte[] encrypt = Base64.getDecoder().decode(encrypted);
            SecretKeySpec aesKey = new SecretKeySpec(Key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            decrypted = new String(cipher.doFinal(encrypt));
        }
        catch (Exception e) {
            decrypted = encrypted;
            logger.log(Level.WARNING, "Unable to decrypt string, may be it was not encrypted properly :: " + e.getMessage());
        }
        return decrypted;
    }

    public static String encryptUsingKey(String textToEncrypt, String key) {
        String str = null;
        try {
            key = ContentCrypto.getPlainTextFromDateString(key);
            key = ("0000000000000000" + key).substring(key.length());
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] encrypted = cipher.doFinal(textToEncrypt.getBytes(StandardCharsets.UTF_8));
            str = Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in encryptUsingKey() :: ", e);
        }
        return str;
    }

    public static String decryptUsingKey(String encrypted, String key) {
        String decrypted = null;
        try {
            key = ContentCrypto.getPlainTextFromDateString(key);
            key = ("0000000000000000" + key).substring(key.length());
            byte[] encrypt = Base64.getDecoder().decode(encrypted);
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            decrypted = new String(cipher.doFinal(encrypt));
        }
        catch (Exception e) {
            decrypted = encrypted;
            logger.log(Level.WARNING, "Unable to decrypt string, may be it was not encrypted properly :: " + e.getMessage());
        }
        return decrypted;
    }

    public static byte[] encryptImageFileContent(String dateStringKey, byte[] byteArrayInputStream) {
        try {
            byte[] encrypted = null;
            byte[] salt = new byte[16];
            dateStringKey = ContentCrypto.getPlainTextFromDateString(dateStringKey);
            byte[] dateStringB = Base64.getDecoder().decode(dateStringKey.getBytes(StandardCharsets.UTF_8));
            PBEKeySpec spec = new PBEKeySpec(new String(dateStringB).toCharArray(), salt, 65536, 256);
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] key = f.generateSecret(spec).getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, keySpec);
                encrypted = cipher.doFinal(byteArrayInputStream);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while encrypting a text in encryptImageFile()::" + e);
            }
            return encrypted;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred creating secret key in encryptImageFile()::" + e);
            return null;
        }
    }

    public static byte[] decryptImageFileContent(String dateStringKey, byte[] bytesOfInputStream) {
        try {
            byte[] decrypted = null;
            byte[] salt = new byte[16];
            dateStringKey = ContentCrypto.getPlainTextFromDateString(dateStringKey);
            byte[] dateStringB = Base64.getDecoder().decode(dateStringKey.getBytes(StandardCharsets.UTF_8));
            PBEKeySpec spec = new PBEKeySpec(new String(dateStringB).toCharArray(), salt, 65536, 256);
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] key = f.generateSecret(spec).getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, keySpec);
                decrypted = cipher.doFinal(bytesOfInputStream);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while decrypting a text in decryptImageFile()::" + e);
            }
            return decrypted;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred creating secret key in decryptImageFile()::" + e);
            return null;
        }
    }

    private static String getPlainTextFromDateString(String dateString) {
        String plainText = null;
        plainText = dateString.replaceAll("\\s", "");
        plainText = plainText.replaceAll("[\\-\\:,]", "");
        return plainText;
    }
}

