/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.deployment;

import com.google.inject.Inject;
import java.io.IOException;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.marshaller.Marshaller;
import org.appops.service.exception.DeploymentException;
import org.appops.web.jetty.server.JettyContainer;

public class ServiceJettyLauncher {
    private Marshaller marshaller;
    private ConfigurationStore configurationStore;
    private JettyContainer jettyContainer;

    public boolean launch(ServiceConfiguration serviceConfiguration) {
        try {
            this.getJettyContainer().deployWebapp(serviceConfiguration.getWebConfig().getPort(), serviceConfiguration.getWebConfig().getContextPath(), serviceConfiguration.getWebappDirectory().toURI().toURL(), serviceConfiguration.getServiceName(), serviceConfiguration.getJettyConfig());
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        return true;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    @Inject
    public void setConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationStore = configurationStore;
    }

    public JettyContainer getJettyContainer() {
        return this.jettyContainer;
    }

    @Inject
    public void setJettyContainer(JettyContainer jettyContainer) {
        this.jettyContainer = jettyContainer;
    }
}

