/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.entrypoint;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.appops.configuration.ModuleConfig;
import org.appops.configuration.guice.ConfigServiceModule;
import org.appops.configuration.loader.ConfigurationLoader;
import org.appops.configuration.slimimpl.SlimImplStructure;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.CoreModule;
import org.appops.core.ServiceException;
import org.appops.core.deployment.DeploymentMode;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.logging.guice.DefaultLoggerModule;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.marshaller.guice.MarshallerModule;
import org.appops.service.ServiceInitializer;
import org.appops.service.deployment.ServiceJettyLauncher;
import org.appops.service.entrypoint.ServiceArgs;
import org.appops.service.exception.AppEntryPointException;
import org.appops.service.exception.DeploymentException;
import org.appops.service.injection.ServiceBaseModule;
import org.appops.web.jetty.JettyWebServiceModule;

public class ServiceEntryPoint {
    private static Injector BASE_INJECTOR = null;

    public void startService(String[] args) throws ServiceException {
        this.startService(new ServiceArgs(args));
    }

    protected void startService(ServiceArgs serviceArgs) {
        try {
            ServiceEntryPoint.createBaseInjector();
            String configString = FileUtils.readFileToString(serviceArgs.getServiceConfig(), StandardCharsets.UTF_8);
            Marshaller marshaller = BASE_INJECTOR.getInstance(Marshaller.class);
            DescriptorType descriptorType = DescriptorType.fromExtension(serviceArgs.getServiceConfig().getName());
            ServiceConfiguration serviceConfiguration = marshaller.unmarshall(configString, ServiceConfiguration.class, descriptorType);
            String serviceDeploymentMode = serviceArgs.getDeploymentMode();
            this.setDeployementMode(serviceDeploymentMode, serviceConfiguration);
            String depConfigLight = marshaller.marshall(serviceConfiguration.lightweightCopy(), descriptorType);
            ConfigurationStore configurationStore = BASE_INJECTOR.getInstance(ConfigurationStore.class);
            configurationStore.addConfiguration(ServiceConfiguration.class.getCanonicalName(), depConfigLight, descriptorType);
            String profileName = serviceArgs.getSelectedProfileName();
            String profileRoot = serviceArgs.getProfileRoot();
            File folder = new File(profileRoot + profileName);
            File[] listOfFiles = folder.listFiles();
            HashMap<String, ServiceConfiguration> serviceConfigMap = new HashMap<String, ServiceConfiguration>();
            for (File file : listOfFiles) {
                File[] files;
                if (!file.isDirectory()) continue;
                String slimImplServiceName = file.getName();
                boolean isCoreService = false;
                if (serviceConfiguration.getServiceName().equals(slimImplServiceName)) {
                    isCoreService = true;
                }
                for (File slimImplconfigfile : files = file.listFiles()) {
                    String configFileName = slimImplconfigfile.getName();
                    if (!this.isYamlFile(configFileName)) continue;
                    if (isCoreService) {
                        this.populateServiceConfiguration(marshaller, slimImplconfigfile, serviceConfiguration, serviceConfigMap);
                        continue;
                    }
                    if (serviceDeploymentMode.equalsIgnoreCase(DeploymentMode.CLUBBED.toString()) && this.isImplYml(configFileName)) {
                        this.populateClubbedConfiguration(marshaller, slimImplconfigfile, slimImplServiceName, serviceConfigMap, serviceConfiguration.getMode());
                        continue;
                    }
                    if (!serviceDeploymentMode.equalsIgnoreCase(DeploymentMode.STANDALONE.toString()) || this.isImplYml(configFileName)) continue;
                    this.populateStandaloneConfiguration(marshaller, slimImplconfigfile, slimImplServiceName, serviceConfigMap, serviceConfiguration.getMode());
                }
            }
            Injector appInjector = ServiceEntryPoint.createAppInjector(BASE_INJECTOR, serviceConfigMap, serviceConfiguration.getMode(), serviceConfiguration);
            this.initializeServices(serviceConfigMap, appInjector, serviceConfiguration, profileName, profileRoot);
            ServiceJettyLauncher appLauncher = appInjector.getInstance(ServiceJettyLauncher.class);
            System.setProperty("currentProfile", profileName);
            System.setProperty("baseUrl", serviceConfiguration.serviceUrl());
            appLauncher.launch(serviceConfiguration);
        }
        catch (Exception e) {
            throw new AppEntryPointException(e);
        }
    }

    private boolean isYamlFile(String configFileName) {
        return configFileName.endsWith(".yml") || configFileName.endsWith(".yaml");
    }

    private void populateServiceConfiguration(Marshaller marshaller, File slimImplconfigfile, ServiceConfiguration serviceConfiguration, HashMap<String, ServiceConfiguration> serviceConfigMap) throws Exception {
        String serviceconfigString = FileUtils.readFileToString(slimImplconfigfile, StandardCharsets.UTF_8);
        DescriptorType configDescriptorType = DescriptorType.fromExtension(slimImplconfigfile.getName());
        SlimImplStructure slimImplConfig = marshaller.unmarshall(serviceconfigString, SlimImplStructure.class, configDescriptorType);
        if (slimImplconfigfile.getName().endsWith("slim.yml")) {
            serviceConfiguration.getModules().getSlimModules().addAll(slimImplConfig.getModules());
            serviceConfigMap.put(serviceConfiguration.getServiceName(), serviceConfiguration);
        } else if (slimImplconfigfile.getName().endsWith("impl.yml")) {
            serviceConfiguration.getModules().getImplModules().addAll(slimImplConfig.getModules());
            serviceConfigMap.put(serviceConfiguration.getServiceName(), serviceConfiguration);
        }
    }

    private void setDeployementMode(String serviceDeploymentMode, ServiceConfiguration serviceConfiguration) throws Exception {
        block4: {
            if (serviceDeploymentMode.equals(DeploymentMode.STANDALONE.name())) {
                serviceConfiguration.setMode(DeploymentMode.STANDALONE);
                break block4;
            }
            if (serviceDeploymentMode.equals(DeploymentMode.CLUBBED.name())) {
                serviceConfiguration.setMode(DeploymentMode.CLUBBED);
                break block4;
            }
            throw new ServiceException("Invalid Deployment Mode :" + serviceDeploymentMode);
        }
    }

    private void populateStandaloneConfiguration(Marshaller marshaller, File configfile, String slimConfigServiceName, HashMap<String, ServiceConfiguration> serviceConfigMap, DeploymentMode deploymentMode) throws Exception {
        String serviceconfigString = FileUtils.readFileToString(configfile, StandardCharsets.UTF_8);
        DescriptorType configDescriptorType = DescriptorType.fromExtension(configfile.getName());
        SlimImplStructure slimImplConfig = marshaller.unmarshall(serviceconfigString, SlimImplStructure.class, configDescriptorType);
        ServiceConfiguration serviceConfiguration = this.populateServiceConfiguration(slimImplConfig, slimConfigServiceName, deploymentMode);
        serviceConfigMap.put(slimConfigServiceName, serviceConfiguration);
    }

    private void populateClubbedConfiguration(Marshaller marshaller, File configfile, String implConfigServiceName, HashMap<String, ServiceConfiguration> serviceConfigMap, DeploymentMode deploymentMode) throws Exception {
        String serviceconfigString = FileUtils.readFileToString(configfile, StandardCharsets.UTF_8);
        DescriptorType configDescriptorType = DescriptorType.fromExtension(configfile.getName());
        SlimImplStructure slimImplConfig = marshaller.unmarshall(serviceconfigString, SlimImplStructure.class, configDescriptorType);
        ServiceConfiguration serviceConfiguration = this.populateServiceConfiguration(slimImplConfig, implConfigServiceName, deploymentMode);
        serviceConfigMap.put(implConfigServiceName, serviceConfiguration);
    }

    private ServiceConfiguration populateServiceConfiguration(SlimImplStructure slimImplConfig, String slimImplServiceName, DeploymentMode deploymentMode) throws Exception {
        if (slimImplConfig != null) {
            ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
            serviceConfiguration.setAnnotationClass(Class.forName(slimImplConfig.getAnnotationClass()));
            serviceConfiguration.setServiceConfig(slimImplConfig.getConfig());
            serviceConfiguration.setServiceName(slimImplServiceName);
            if (deploymentMode.equals((Object)DeploymentMode.STANDALONE)) {
                ModuleConfig slimModduleConfig = new ModuleConfig();
                slimModduleConfig.setSlimModules(slimImplConfig.getModules());
                serviceConfiguration.setModules(slimModduleConfig);
            } else if (deploymentMode.equals((Object)DeploymentMode.CLUBBED)) {
                ModuleConfig implModuleConfig = new ModuleConfig();
                implModuleConfig.setImplModules(slimImplConfig.getModules());
                serviceConfiguration.setModules(implModuleConfig);
            } else {
                throw new DeploymentException("Deployment mode not matched " + deploymentMode.name());
            }
            return serviceConfiguration;
        }
        return null;
    }

    private boolean isImplYml(String configFileName) {
        return configFileName.endsWith("impl.yml");
    }

    private static Injector createBaseInjector() {
        if (BASE_INJECTOR == null) {
            ArrayList<CoreModule> modules = new ArrayList<CoreModule>();
            modules.add(new ConfigServiceModule());
            modules.add(new MarshallerModule());
            modules.add(new DefaultLoggerModule());
            BASE_INJECTOR = Guice.createInjector(modules);
        }
        return BASE_INJECTOR;
    }

    private void initializeServices(Map<String, ServiceConfiguration> services, Injector appInjector, ServiceConfiguration entryPointConfig, String currentProfile, String profileRoot) {
        ClassPathAnalyser classPathAnalyser = new ClassPathAnalyser(entryPointConfig.getPackageToScan());
        Collection<Class<? extends ServiceInitializer>> initializers = classPathAnalyser.subTypesOf(ServiceInitializer.class);
        String currentService = entryPointConfig.getServiceName();
        String baseConfigPath = profileRoot + currentProfile;
        ServiceEntryPoint.initializeService(currentService, entryPointConfig, appInjector, initializers, baseConfigPath, entryPointConfig.getMode(), true);
        for (String serviceName : services.keySet()) {
            if (serviceName.contentEquals(currentService)) continue;
            ServiceConfiguration config = services.get(serviceName);
            ServiceEntryPoint.initializeService(serviceName, config, appInjector, initializers, baseConfigPath, entryPointConfig.getMode(), false);
        }
    }

    private static void initializeService(String serviceName, ServiceConfiguration config, Injector appInjector, Collection<Class<? extends ServiceInitializer>> initializers, String baseConfigPath, DeploymentMode deploymentMode, boolean isCurrentService) {
        File ymlConfig = new File((baseConfigPath = baseConfigPath.endsWith("/") ? baseConfigPath : baseConfigPath + "/") + serviceName + "/");
        if (ymlConfig.exists()) {
            if (ymlConfig.isDirectory()) {
                ServiceEntryPoint.loadConfig(serviceName, ymlConfig, appInjector, deploymentMode, isCurrentService);
            } else {
                System.out.println("Warning : Configuration for " + serviceName + " does not exist on path -> " + ymlConfig.getPath());
            }
        }
        Class<?> serviceAnnotation = config.getAnnotationClass();
        for (Class<? extends ServiceInitializer> initializer : initializers) {
            if (!initializer.isAnnotationPresent(serviceAnnotation)) continue;
            appInjector.getInstance(initializer).initialize(serviceName, config, serviceAnnotation);
            initializers.remove(initializer);
            break;
        }
    }

    private static void loadConfig(String serviceName, File ymlConfig, Injector appInjector, DeploymentMode deploymentMode, boolean isCurrentService) {
        for (File ymlFile : ymlConfig.listFiles()) {
            if (DeploymentMode.STANDALONE.equals((Object)deploymentMode) && !isCurrentService && ymlFile.getName().contentEquals("impl.yml")) continue;
            appInjector.getInstance(ConfigurationLoader.class).loadConfigurationsFromFile(serviceName, ymlFile);
        }
    }

    private static Injector createAppInjector(Injector BASE_INJECTOR, Map<String, ServiceConfiguration> services, DeploymentMode mode, ServiceConfiguration entryPoint) {
        ModuleConfig finalConfig = new ModuleConfig();
        for (String serviceName : services.keySet()) {
            if (entryPoint.getServiceName().equals(serviceName)) continue;
            finalConfig.merge(services.get(serviceName).getModules());
        }
        LinkedHashSet<? extends Module> finalModules = new LinkedHashSet<Module>();
        finalModules.addAll(finalConfig.enabledModules(mode));
        finalModules.addAll(ServiceEntryPoint.getEntryPointServiceModules(entryPoint));
        finalModules.add(new ServiceBaseModule());
        finalModules.add(new JettyWebServiceModule());
        return BASE_INJECTOR.createChildInjector(finalModules);
    }

    private static Collection<? extends Module> getEntryPointServiceModules(ServiceConfiguration entryPoint) {
        ModuleConfig moduleConfig = entryPoint.getModules();
        return moduleConfig.instantiateModules(moduleConfig.getImplModules(), null);
    }
}

