/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.invocation;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.servlet.RequestParameters;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.Parameter;
import org.appops.core.service.meta.MappedOpMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.logging.impl.LogManager;
import org.appops.logging.logger.Logger;
import org.appops.logging.meta.Level;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.exception.InvocationException;
import org.appops.service.invocation.FindAyncImplementation;
import org.appops.service.invocation.MethodLocator;
import org.appops.service.lifecycle.CallStack;
import org.appops.service.store.RequestParameterStore;
import org.appops.slim.base.api.ServiceMetaManager;
import org.appops.slim.base.invocation.UrlEncodeUtil;

public class OperationInvoker {
    private Provider<CallStack> callStackProvider;
    private Provider<MethodLocator> methodLocator;
    private Provider<ServiceMetaManager> serviceMetaManager;
    private Marshaller marshaller;
    private Provider<RequestParameterStore> paramStoreProvider;
    private static final String LOG_SERVICE_NAME = "LogViewer";
    private Logger rootLogger;
    @Inject
    private Injector injector;
    @Inject
    @RequestParameters
    private Provider<Map<String, String[]>> requestParametersProvider;

    @Inject
    public OperationInvoker(Provider<ServiceMetaManager> serviceMetaManager, LogManager logManager) {
        this.serviceMetaManager = serviceMetaManager;
        this.rootLogger = logManager.getRootLogger();
    }

    public Object invoke(String service, String opPathOrSignature) {
        return this.invoke(service, opPathOrSignature, null);
    }

    public Object invoke(String serviceName, String opPathOrSignature, OpParameterMap postData) {
        Class<?> apiClass;
        ServiceOpMeta opMeta = this.getServiceStore().getOpMeta(serviceName, opPathOrSignature);
        ServiceOpMeta finalOperation = this.getMappedOperation(opMeta);
        this.printOpLog(Level.INFO, serviceName, finalOperation.getName(), "Starting operation execution.");
        String apiQualifiedName = finalOperation.getParent().getQualifiedClassName();
        List<Object> params = this.getParameters(postData, opPathOrSignature, finalOperation);
        this.paramStoreProvider.get().setParameters(params);
        try {
            apiClass = Class.forName(apiQualifiedName);
        }
        catch (ClassNotFoundException e1) {
            this.printOpLog(Level.ERROR, serviceName, finalOperation.getName(), "Api/Operation  not found!!!");
            throw new InvocationException("Api  not found, name ->" + apiQualifiedName);
        }
        Method method = this.getMethodLocator().findMethod(apiClass, finalOperation);
        FindAyncImplementation findAyncImplementation = new FindAyncImplementation();
        Class<?> asyncImplClass = findAyncImplementation.getAsyncImplementation(apiClass);
        Object result = null;
        Object[] paramRaw = params.toArray();
        try {
            if (asyncImplClass != null) {
                try {
                    Object service = this.injector.getInstance(asyncImplClass);
                    result = this.invokeAsyncImplementation(asyncImplClass, method, paramRaw, service);
                }
                catch (ConfigurationException e) {
                    this.rootLogger.withMessage("Implementation not found for " + asyncImplClass);
                    result = this.invokeSyncImplementation(apiClass, method, paramRaw);
                }
            } else {
                result = this.invokeSyncImplementation(apiClass, method, paramRaw);
            }
        }
        catch (Exception e) {
            throw new InvocationException(e.getCause());
        }
        this.printOpLog(Level.INFO, serviceName, finalOperation.getName(), "Completed operation execution.");
        return result;
    }

    private Object invokeSyncImplementation(Class<?> apiClass, Method method, Object[] paramRaw) {
        Object service = null;
        try {
            service = this.injector.getInstance(apiClass);
            if (method.getParameterTypes().length > 0 && method.isVarArgs()) {
                Object[] argumentArray = new Object[]{paramRaw};
                return method.invoke(service, new Object[]{argumentArray});
            }
            return method.invoke(service, paramRaw);
        }
        catch (Exception e) {
            throw new InvocationException(e.getCause());
        }
    }

    private Object invokeAsyncImplementation(Class<?> asyncImplClass, Method method, Object[] paramRaw, Object service) {
        try {
            Method asyncMethod = asyncImplClass.getMethod(method.getName(), method.getParameterTypes());
            if (asyncMethod.getParameterTypes().length > 0 && asyncMethod.isVarArgs()) {
                Object[] argumentArray = new Object[]{paramRaw};
                CompletableFuture completableFuture = (CompletableFuture)asyncMethod.invoke(service, new Object[]{argumentArray});
                return completableFuture.get();
            }
            CompletableFuture completableFuture = (CompletableFuture)asyncMethod.invoke(service, paramRaw);
            return completableFuture.get();
        }
        catch (Exception e) {
            throw new InvocationException(e.getCause());
        }
    }

    private void printOpLog(Level level, String service, String opName, String logMessage) {
        if (LOG_SERVICE_NAME.toLowerCase().equals(service.toLowerCase())) {
            return;
        }
        String finalMessage = "Service operation log :  Service_Name -> " + service + ", Operation_Name -> " + opName;
        if (logMessage != null && !logMessage.isEmpty()) {
            finalMessage = finalMessage + ", Detailed message :- " + logMessage;
        }
        this.rootLogger.withLevel(level).withMessage(finalMessage).log();
    }

    private List<Object> getParameters(OpParameterMap postData, String opPathOrSignature, ServiceOpMeta finalOperation) {
        List<Object> params = postData != null && !postData.isEmpty() ? this.fromPostData(postData, finalOperation) : this.fromRequestOrPathParameters(opPathOrSignature, finalOperation, this.getRequestParameters());
        return params;
    }

    private List<Object> fromPostData(OpParameterMap postData, ServiceOpMeta finalOperation) {
        ArrayList<Object> paramsToReturn = new ArrayList<Object>();
        for (Integer order : postData.keySet()) {
            Class<?> typeClazz;
            Parameter parameter = (Parameter)postData.get(order);
            Object value = parameter.getValue();
            parameter = (Parameter)finalOperation.getParameters().get(order);
            try {
                if (parameter.getTypeName().equals("java.lang.Byte[]")) {
                    parameter.setTypeName("[Ljava.lang.Byte;");
                }
                typeClazz = Class.forName(parameter.getTypeName());
            }
            catch (Exception e) {
                throw new InvocationException("Cannot find type for parameter -> " + parameter.getName() + " type-name -> " + parameter.getTypeName());
            }
            if (!typeClazz.isAssignableFrom(value.getClass())) {
                String stringVal;
                if (value instanceof String) {
                    stringVal = (String)value;
                    if (typeClazz.isEnum()) {
                        value = Enum.valueOf(typeClazz, stringVal);
                        stringVal = null;
                    }
                } else {
                    stringVal = this.getMarshaller().marshall(value, DescriptorType.JSON);
                }
                if (stringVal != null) {
                    value = this.getMarshaller().unmarshall(stringVal, typeClazz, DescriptorType.JSON);
                }
            }
            paramsToReturn.add(value);
        }
        return paramsToReturn;
    }

    private List<Object> fromRequestOrPathParameters(String path, ServiceOpMeta finalOperation, Map<String, String[]> requestParameters) {
        LinkedList<String[]> requestParamList = new LinkedList<String[]>(requestParameters.values());
        Map<String, String> pathParams = this.extractPathParameters(path, finalOperation.getPath());
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (Parameter parameter : finalOperation.getParameters().values()) {
            Class<?> typeClazz;
            String parameterName = parameter.getName();
            String strVal = null;
            if (pathParams.containsKey(parameterName)) {
                strVal = pathParams.get(parameterName);
            } else {
                String[] valArr = null;
                if (requestParameters.containsKey(parameterName)) {
                    valArr = requestParameters.get(parameterName);
                } else {
                    int order = parameter.getOrder();
                    valArr = (String[])requestParamList.get(order);
                }
                if (valArr != null && valArr.length > 0) {
                    strVal = valArr[0];
                }
            }
            try {
                typeClazz = Class.forName(parameter.getTypeName());
            }
            catch (Exception e) {
                throw new InvocationException("Cannot find type for parameter -> " + parameter.getName() + " type-name -> " + parameter.getTypeName());
            }
            if (strVal != null && !strVal.equals("null")) {
                if (String.class.isAssignableFrom(typeClazz)) {
                    paramList.add(strVal);
                    continue;
                }
                Object value = this.getMarshaller().unmarshall(strVal, typeClazz, DescriptorType.JSON);
                paramList.add(value);
                continue;
            }
            paramList.add(null);
        }
        return paramList;
    }

    private Map<String, String> extractPathParameters(String path, String metaPath) {
        UrlEncodeUtil decoder = new UrlEncodeUtil();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (metaPath != null && metaPath.contains("/") && path.contains("/")) {
            String[] metaElements = metaPath.split("/");
            String[] pathElements = path.split("/");
            for (int i = 0; i < metaElements.length; ++i) {
                String metaElement = metaElements[i];
                if (!metaElement.startsWith("{") || !metaElement.endsWith("}")) continue;
                String parameterName = metaElement.substring(metaElement.indexOf("{") + 1, metaElement.indexOf("}")).trim();
                String value = pathElements[i];
                pathParams.put(parameterName, decoder.decodePathParam(value));
            }
        }
        return pathParams;
    }

    private ServiceOpMeta getMappedOperation(ServiceOpMeta op) {
        if (op instanceof MappedOpMeta) {
            ServiceOpMeta mappedDestination = this.getServiceStore().getOpMeta(((MappedOpMeta)op).getMappedTo());
            if (mappedDestination.isDynamic()) {
                this.getCallStack().addOperation(mappedDestination);
            }
            if (mappedDestination instanceof MappedOpMeta) {
                return this.getMappedOperation(mappedDestination);
            }
            return mappedDestination;
        }
        return op;
    }

    public CallStack getCallStack() {
        return this.callStackProvider.get();
    }

    @Inject
    public void setCallStackProvider(Provider<CallStack> callStackProvider) {
        this.callStackProvider = callStackProvider;
    }

    private Map<String, String[]> getRequestParameters() {
        return this.requestParametersProvider.get();
    }

    public MethodLocator getMethodLocator() {
        return this.methodLocator.get();
    }

    @Inject
    public void setMethodLocator(Provider<MethodLocator> methodLocator) {
        this.methodLocator = methodLocator;
    }

    public void setRequestParametersProvider(Provider<Map<String, String[]>> requestParametersProvider) {
        this.requestParametersProvider = requestParametersProvider;
    }

    public ServiceMetaManager getServiceStore() {
        return this.serviceMetaManager.get();
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Provider<RequestParameterStore> getParamStoreProvider() {
        return this.paramStoreProvider;
    }

    @Inject
    public void setParamStoreProvider(Provider<RequestParameterStore> paramStoreProvider) {
        this.paramStoreProvider = paramStoreProvider;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public Provider<ServiceMetaManager> getServiceMetaManager() {
        return this.serviceMetaManager;
    }

    public void setServiceMetaManager(Provider<ServiceMetaManager> serviceMetaManager) {
        this.serviceMetaManager = serviceMetaManager;
    }
}

