/*
 * Decompiled with CFR 0.152.
 */
package org.appops.web.jetty.client;

import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.appops.core.mime.MimeType;
import org.appops.web.common.client.AsyncWebClient;
import org.appops.web.common.client.Cookie;
import org.appops.web.common.client.Proxy;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.asynchttpclient.cookie.CookieStore;
import org.asynchttpclient.uri.Uri;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;

public class AsynHttpClient
extends AsyncWebClient<AsyncHttpClient> {
    public AsynHttpClient() {
        AsyncHttpClient client = Dsl.asyncHttpClient();
        this.setWrappedAsyncHttpClient(client);
    }

    private static AsyncHttpClient createHttpClient() {
        DefaultAsyncHttpClientConfig.Builder clientBuilder = Dsl.config().setConnectTimeout(500);
        AsyncHttpClient client = Dsl.asyncHttpClient(clientBuilder);
        return client;
    }

    @Override
    public CompletableFuture<Response> get(String url) {
        return this.get(url, null);
    }

    @Override
    public CompletableFuture<Response> get(String url, Cookie cookie) {
        CompletableFuture<Response> response = ((AsyncHttpClient)this.wrappedAsyncHttpClient()).prepareGet(url).execute().toCompletableFuture();
        return response;
    }

    @Override
    public CompletableFuture<Response> post(String url, Object content, MimeType contentType) {
        return this.post(url, content, contentType, null);
    }

    @Override
    public CompletableFuture<Response> post(String url, Object content, MimeType contentType, Cookie cookie) {
        CompletableFuture<Response> response = ((BoundRequestBuilder)((AsyncHttpClient)this.wrappedAsyncHttpClient()).preparePost(url).setBody(content.toString())).execute().toCompletableFuture();
        return response;
    }

    private ListenableFuture<Response> processAsyncRequest(Request request) {
        ListenableFuture<Response> listenableFuture = ((AsyncHttpClient)this.wrappedAsyncHttpClient()).executeRequest(request, new AsyncCompletionHandler<Response>(){

            @Override
            public Response onCompleted(Response response) throws Exception {
                return response;
            }
        });
        return listenableFuture;
    }

    public CompletableFuture<String> helperFunction() {
        ExecutorService executor = Executors.newCachedThreadPool();
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> "42", executor);
        return future;
    }

    @Override
    public void addCookie(String url, Cookie cookie) {
        CookieStore cookieStore = ((AsyncHttpClient)this.wrappedAsyncHttpClient()).getConfig().getCookieStore();
        DefaultCookie defaultCookie = this.createHttpCookie(cookie);
        cookieStore.add(Uri.create(url), defaultCookie);
    }

    @Override
    public void addProxy(Proxy proxy) {
    }

    private HttpProxy createHttpProxy(Proxy proxy) {
        HttpProxy httpProxy = new HttpProxy(new Origin.Address(proxy.host(), proxy.port()), proxy.isSecure());
        return httpProxy;
    }

    DefaultCookie createHttpCookie(Cookie cookie) {
        DefaultCookie httpCookie = new DefaultCookie(cookie.name(), cookie.value());
        httpCookie.setDomain(cookie.domain());
        httpCookie.setHttpOnly(cookie.isHttpOnly());
        httpCookie.setMaxAge(cookie.maxAge());
        httpCookie.setSecure(cookie.isSecure());
        httpCookie.setPath(cookie.path());
        return httpCookie;
    }
}

