/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.common.exception.ConfigurationException;
import org.restexpress.domain.metadata.RouteMetadata;
import org.restexpress.domain.metadata.UriMetadata;
import org.restexpress.route.Route;
import org.restexpress.settings.RouteDefaults;

public abstract class RouteBuilder {
    static final String DELETE_ACTION_NAME = "delete";
    static final String GET_ACTION_NAME = "read";
    static final String POST_ACTION_NAME = "create";
    static final String PUT_ACTION_NAME = "update";
    static final List<HttpMethod> DEFAULT_HTTP_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE);
    static final Map<HttpMethod, String> ACTION_MAPPING = new HashMap<HttpMethod, String>();
    private String uri;
    private List<HttpMethod> methods = new ArrayList<HttpMethod>();
    private List<String> supportedFormats = new ArrayList<String>();
    private String defaultFormat = null;
    private Map<HttpMethod, String> actionNames = new HashMap<HttpMethod, String>();
    private Object controller;
    private boolean shouldSerializeResponse = true;
    private String name;
    private String baseUrl;
    private Set<String> flags = new HashSet<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public RouteBuilder(String uri, Object controller, RouteDefaults defaults) {
        this.uri = uri;
        this.controller = controller;
        this.applyDefaults(defaults);
    }

    public RouteBuilder action(String action, HttpMethod method) {
        if (!this.actionNames.containsKey(method)) {
            this.actionNames.put(method, action);
        }
        if (!this.methods.contains(method)) {
            this.methods.add(method);
        }
        return this;
    }

    public RouteBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public RouteBuilder method(HttpMethod ... methods) {
        for (HttpMethod method : methods) {
            if (this.methods.contains(method)) continue;
            this.methods.add(method);
        }
        return this;
    }

    public RouteBuilder noSerialization() {
        this.shouldSerializeResponse = false;
        return this;
    }

    public RouteBuilder performSerialization() {
        this.shouldSerializeResponse = true;
        return this;
    }

    public RouteBuilder name(String name) {
        this.name = name;
        return this;
    }

    public RouteBuilder format(String format) {
        if (!this.supportedFormats.contains(format)) {
            this.supportedFormats.add(format);
        }
        return this;
    }

    public RouteBuilder defaultFormat(String format) {
        this.defaultFormat = format;
        return this;
    }

    public RouteBuilder flag(String flagValue) {
        this.flags.add(flagValue);
        return this;
    }

    public RouteBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public RouteBuilder useStreamingMultipartUpload() {
        return this;
    }

    public RouteBuilder useStreamingDownload() {
        return this;
    }

    public List<Route> build() {
        if (this.methods.isEmpty()) {
            this.methods = DEFAULT_HTTP_METHODS;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        String pattern = this.toRegexPattern(this.uri);
        for (HttpMethod method : this.methods) {
            String actionName = this.actionNames.get(method);
            if (actionName == null && (actionName = ACTION_MAPPING.get(method)) == null) {
                actionName = method.name().toLowerCase();
            }
            Method action = this.determineActionMethod(this.controller, actionName);
            routes.add(this.newRoute(pattern, this.controller, action, method, this.shouldSerializeResponse, this.name, this.supportedFormats, this.defaultFormat, this.flags, this.parameters, this.baseUrl));
        }
        return routes;
    }

    protected abstract String toRegexPattern(String var1);

    public RouteMetadata asMetadata() {
        RouteMetadata metadata = new RouteMetadata();
        metadata.setName(this.name);
        metadata.setSerialized(this.shouldSerializeResponse);
        metadata.setDefaultFormat(this.defaultFormat);
        metadata.addAllSupportedFormats(this.supportedFormats);
        metadata.setBaseUrl(this.baseUrl);
        UriMetadata uriMeta = new UriMetadata(this.uri);
        List<Route> routes = this.build();
        for (Route route : routes) {
            uriMeta.addAllParameters(route.getUrlParameters());
            metadata.addMethod(route.getMethod().name());
        }
        metadata.setUri(uriMeta);
        return metadata;
    }

    protected abstract Route newRoute(String var1, Object var2, Method var3, HttpMethod var4, boolean var5, String var6, List<String> var7, String var8, Set<String> var9, Map<String, Object> var10, String var11);

    protected Method determineActionMethod(Object controller, String actionName) {
        try {
            return controller.getClass().getMethod(actionName, Request.class, Response.class);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected void applyDefaults(RouteDefaults defaults) {
        if (defaults == null) {
            return;
        }
        this.defaultFormat(defaults.getDefaultFormat());
        this.baseUrl(defaults.getBaseUrl());
    }

    static {
        ACTION_MAPPING.put(HttpMethod.DELETE, DELETE_ACTION_NAME);
        ACTION_MAPPING.put(HttpMethod.GET, GET_ACTION_NAME);
        ACTION_MAPPING.put(HttpMethod.POST, POST_ACTION_NAME);
        ACTION_MAPPING.put(HttpMethod.PUT, PUT_ACTION_NAME);
    }
}

