/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.url;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringParser {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final String uri;
    private final boolean hasPath;
    private final int maxParams;
    private String path;
    private Map<String, List<String>> params;
    private int nParams;

    public QueryStringParser(String uri) {
        this(uri, true);
    }

    public QueryStringParser(String uri, boolean hasPath) {
        this(uri, hasPath, 1024);
    }

    public QueryStringParser(URI uri) {
        this(uri, 1024);
    }

    public QueryStringParser(String uri, boolean hasPath, int maxParams) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: a positive integer)");
        }
        this.uri = uri.replace(';', '&');
        this.maxParams = maxParams;
        this.hasPath = hasPath;
    }

    public QueryStringParser(URI uri, int maxParams) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: a positive integer)");
        }
        String rawPath = uri.getRawPath();
        if (rawPath != null) {
            this.hasPath = true;
        } else {
            rawPath = "";
            this.hasPath = false;
        }
        String newUri = rawPath + "?" + uri.getRawQuery();
        this.uri = newUri.replace(';', '&');
        this.maxParams = maxParams;
    }

    public String getPath() {
        if (this.path == null) {
            if (!this.hasPath) {
                this.path = "";
                return "";
            }
            int pathEndPos = this.uri.indexOf(63);
            if (pathEndPos < 0) {
                this.path = this.uri;
            } else {
                this.path = this.uri.substring(0, pathEndPos);
                return this.path;
            }
        }
        return this.path;
    }

    public Map<String, List<String>> getParameters() {
        if (this.params == null) {
            if (this.hasPath) {
                int pathLength = this.getPath().length();
                if (this.uri.length() == pathLength) {
                    return Collections.emptyMap();
                }
                this.parseParams(this.uri.substring(pathLength + 1));
            } else {
                if (this.uri.length() == 0) {
                    return Collections.emptyMap();
                }
                this.parseParams(this.uri);
            }
        }
        return this.params;
    }

    private void parseParams(String s) {
        int i;
        this.params = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> params = this.params;
        this.nParams = 0;
        String name = null;
        int pos = 0;
        char c = '\u0000';
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = s.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (name == null && pos != i) {
                if (!this.addParam(params, s.substring(pos, i), "")) {
                    return;
                }
            } else if (name != null) {
                if (!this.addParam(params, name, s.substring(pos, i))) {
                    return;
                }
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i ? (name == null ? !this.addParam(params, s.substring(pos, i), "") : !this.addParam(params, name, s.substring(pos, i))) : name != null && !this.addParam(params, name, "")) {
            return;
        }
    }

    private boolean addParam(Map<String, List<String>> params, String name, String value) {
        if (this.nParams >= this.maxParams) {
            return false;
        }
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        ++this.nParams;
        return true;
    }
}

