/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.util;

import io.netty.handler.codec.http.HttpResponseStatus;
import org.restexpress.Response;
import org.restexpress.exception.HttpSpecificationException;

public final class HttpSpecification {
    private HttpSpecification() {
    }

    public static void enforce(Response response) {
        int status = response.getResponseStatus().code();
        if (HttpSpecification.is1xx(status)) {
            HttpSpecification.enforce1xx(response);
        } else {
            switch (status) {
                case 204: {
                    HttpSpecification.enforce204(response);
                    break;
                }
                case 304: {
                    HttpSpecification.enforce304(response);
                    break;
                }
                case 405: {
                    HttpSpecification.enforce405(response);
                    break;
                }
            }
        }
    }

    public static boolean isContentTypeAllowed(Response response) {
        return HttpSpecification.isContentAllowed(response);
    }

    public static boolean isContentLengthAllowed(Response response) {
        return HttpSpecification.isContentAllowed(response);
    }

    public static boolean isContentAllowed(Response response) {
        HttpResponseStatus status = response.getResponseStatus();
        return !HttpResponseStatus.NO_CONTENT.equals(status) && !HttpResponseStatus.NOT_MODIFIED.equals(status) && !HttpSpecification.is1xx(status.code());
    }

    private static boolean is1xx(int status) {
        return 100 <= status && status <= 199;
    }

    private static void enforce1xx(Response response) {
        HttpSpecification.ensureNoBody(response);
        HttpSpecification.ensureNoContentType(response);
        HttpSpecification.ensureNoContentLength(response);
    }

    private static void enforce204(Response response) {
        HttpSpecification.ensureNoBody(response);
        HttpSpecification.ensureNoContentType(response);
        HttpSpecification.ensureNoContentLength(response);
    }

    private static void enforce304(Response response) {
        HttpSpecification.ensureNoBody(response);
        HttpSpecification.ensureNoContentType(response);
        HttpSpecification.ensureNoContentLength(response);
    }

    private static void enforce405(Response response) {
        HttpSpecification.ensureAllowHeader(response);
    }

    private static void ensureNoBody(Response response) {
        if (response.hasBody()) {
            throw new HttpSpecificationException("HTTP 1.1 specification: must not contain response body with status: " + response.getResponseStatus());
        }
    }

    private static void ensureNoContentLength(Response response) {
        if (response.getHeader("Content-Length") != null) {
            throw new HttpSpecificationException("HTTP 1.1 specification: must not contain Content-Length header for status: " + response.getResponseStatus());
        }
    }

    private static void ensureNoContentType(Response response) {
        if (response.getHeader("Content-Type") != null) {
            throw new HttpSpecificationException("HTTP 1.1 specification: must not contain Content-Type header for status: " + response.getResponseStatus());
        }
    }

    private static void ensureAllowHeader(Response response) {
        if (response.getHeader("Allow") == null) {
            throw new HttpSpecificationException("HTTP 1.1 specification: must contain Allow header for status: " + response.getResponseStatus());
        }
    }
}

