/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.logger.config;

import java.util.ArrayList;
import java.util.List;
import org.appops.core.annotation.CoreConfig;
import org.appops.log.service.slim.service.Level;
import org.appops.logging.logger.config.HandlerConfig;
import org.appops.logging.logger.config.StorageConfig;
import org.appops.logging.logger.config.constant.HandlerAttribute;
import org.appops.logging.logger.config.constant.HandlerType;
import org.appops.logging.logger.config.constant.LoggerType;

@CoreConfig
public class LoggerConfig {
    private LoggerType destinationLogger;
    private List<HandlerConfig> handlers;
    private List<LoggerType> overrideLoggers;
    private boolean aggregateLogs = false;
    private Level level;
    private StorageConfig storage;

    public List<LoggerType> getOverrideLoggers() {
        return this.overrideLoggers;
    }

    public LoggerConfig() {
        this.setDestinationLogger(LoggerType.LOG4J);
        this.setLevel(Level.ALL);
        this.addDefaultHandler();
        this.addDefaultStorage();
    }

    private void addDefaultStorage() {
        StorageConfig storageConfig = new StorageConfig();
        storageConfig.setFilepath("LogStorage.log");
        this.setStorage(storageConfig);
    }

    public void addDefaultHandler() {
        HandlerConfig config = new HandlerConfig();
        config.enable();
        config.withName(HandlerType.CONSOLE);
        config.addAttribute(HandlerAttribute.LEVEL, (Object)Level.ALL);
        this.getHandlers().add(config);
    }

    public void setOverrideLoggers(List<LoggerType> overrideLoggers) {
        this.overrideLoggers = overrideLoggers;
    }

    public List<HandlerConfig> getHandlers() {
        if (this.handlers == null) {
            this.handlers = new ArrayList<HandlerConfig>();
        }
        return this.handlers;
    }

    public void setHandlers(List<HandlerConfig> handlers) {
        this.handlers = handlers;
    }

    public LoggerType getDestinationLogger() {
        return this.destinationLogger;
    }

    public void setDestinationLogger(LoggerType destinationLogger) {
        this.destinationLogger = destinationLogger;
    }

    public boolean isAggregateLogs() {
        return this.aggregateLogs;
    }

    public void setAggregateLogs(boolean aggregateLogs) {
        this.aggregateLogs = aggregateLogs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public StorageConfig getStorage() {
        return this.storage;
    }

    public void setStorage(StorageConfig storage) {
        this.storage = storage;
    }
}

