/*
 * Decompiled with CFR 0.152.
 */
package org.appops.marshaller.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import javax.xml.bind.DatatypeConverter;
import org.appops.core.response.Blob;
import org.appops.marshaller.exception.MarshalException;
import org.appops.marshaller.exception.UnmarshalException;
import org.appops.marshaller.json.Jsonizer;
import org.json.JSONObject;

public class JacksonJsonizer
implements Jsonizer {
    private ObjectMapper jsonMapper = this.createJsonMapper();

    @Override
    public String toJson(Object object) {
        try {
            if (object.getClass().getCanonicalName().equals(Blob.class.getCanonicalName())) {
                this.jsonMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            }
            return this.jsonMapper.writeValueAsString(object).trim();
        }
        catch (JsonProcessingException e) {
            throw new MarshalException(e);
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        try {
            if (clazz.getCanonicalName() != Blob.class.getCanonicalName()) {
                return this.jsonMapper.readValue(json, clazz);
            }
            return (T)this.createCustomBlob(json);
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e);
        }
    }

    private Blob createCustomBlob(String json) {
        Blob blob = new Blob();
        JSONObject jsonObj = new JSONObject(json);
        String base64String = ((JSONObject)jsonObj.get("inputStream")).get("buf").toString();
        byte[] bytes = DatatypeConverter.parseBase64Binary(base64String);
        blob.setMimeType((String)jsonObj.get("mimeType"));
        blob.setNameOfFile((String)jsonObj.get("nameOfFile"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        blob.setInputStream(inputStream);
        return blob;
    }

    private ObjectMapper createJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

