/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.injection;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.RequestScoped;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.service.CurrentDeploymentProvider;
import org.appops.service.client.Client;
import org.appops.service.client.ClientProvider;
import org.appops.service.client.handler.ClientHandler;
import org.appops.service.client.handler.ClientHandlerProvider;
import org.appops.service.injection.BaseServletModule;
import org.appops.service.invocation.OperationDecorator;
import org.appops.service.job.JobExecService;
import org.appops.service.job.JobExecServiceImpl;
import org.appops.service.lifecycle.CallStack;
import org.appops.service.request.ServiceApiFilter;
import org.appops.service.store.RequestParameterStore;
import org.appops.service.store.RequestParameterStoreImpl;

public class ServiceBaseModule
extends BaseServletModule {
    @Override
    public void configureModule() {
        this.bind(CallStack.class).in(RequestScoped.class);
        OperationDecorator decorator = new OperationDecorator();
        this.requestInjection(decorator);
        this.bind(ServiceConfiguration.class).annotatedWith(Names.named("CURRENT_DEPLOYMENT")).toProvider(CurrentDeploymentProvider.class).in(Singleton.class);
        this.bind(JobExecService.class).to(JobExecServiceImpl.class);
        this.bind(ServiceApiFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(ServiceApiFilter.class);
        this.bind(Client.class).toProvider(ClientProvider.class).in(RequestScoped.class);
        this.bind(ClientHandler.class).toProvider(ClientHandlerProvider.class).in(RequestScoped.class);
        this.bind(RequestParameterStore.class).to(RequestParameterStoreImpl.class).in(RequestScoped.class);
    }

    @Provides
    @Named(value="ServiceMeta.Origin")
    @RequestScoped
    public ServiceMeta providesOriginService(CallStack provider) {
        return provider.getServiceOfOrigin();
    }

    @Provides
    @Named(value="ServiceMeta.Current")
    public ServiceMeta providesCurrentService(CallStack provider) {
        return provider.getCurrentService();
    }

    @Provides
    @Named(value="ServiceOpMeta.Caller")
    public ServiceOpMeta providesCallerOperation(CallStack stack) {
        return stack.getCallerOperation();
    }

    @Provides
    @Named(value="ServiceOpMeta.Current")
    public ServiceOpMeta providesCurrentOperation(CallStack provider) {
        return provider.getCurrentOperation();
    }
}

