/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.job;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.annotation.JobEntry;
import org.appops.core.job.token.JobToken;
import org.appops.log.service.slim.service.Level;
import org.appops.logging.impl.LogManager;
import org.appops.logging.logger.Logger;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.crypto.ContentCrypto;
import org.appops.service.exception.InvocationException;
import org.appops.service.job.JobExecService;
import org.appops.service.job.JobExecutionException;
import org.appops.service.job.pool.JobPool;

public class JobExecServiceImpl
implements JobExecService {
    @Inject
    private Injector injector;
    private JobPool pool;
    private Logger logger;

    protected JobExecServiceImpl() {
    }

    @Inject
    protected JobExecServiceImpl(LogManager logManager) {
        this.logger = logManager.getRootLogger();
    }

    @Override
    public void executeJob(String token) {
        try {
            JobToken jobToken = this.decryptToken(token);
            if (jobToken != null) {
                Class<?> jobClazz = Class.forName(jobToken.getJobClassName());
                Object jobClassObject = this.injector.getInstance(jobClazz);
                Method method = this.getMethod(jobClazz);
                List<Object> params = this.getParameters(method, jobToken.getParameters());
                this.logger.withLevel(Level.FINE).withMessage("Token submitted for execution :" + jobToken.getGuid());
                this.getPool().submitJob(jobClassObject, params.toArray(), jobToken);
            }
        }
        catch (Exception e) {
            this.logger.withLevel(Level.SEVERE).withMessage("Exception occured in " + this.getClass().getCanonicalName() + "::executeJob() ").withMeta("Exception", e);
            throw new JobExecutionException(e);
        }
    }

    private Method getMethod(Class<?> jobClazz) {
        List<Method> methods = this.injector.getInstance(ClassPathAnalyser.class).getAnnotatedMethods(jobClazz, JobEntry.class);
        if (methods.isEmpty()) {
            throw new InvocationException("Method must have " + JobEntry.class.getName() + " annotation for execution.");
        }
        if (methods.size() > 1) {
            throw new InvocationException("Found more than one method with " + JobEntry.class.getName() + " annotation.");
        }
        return methods.get(0);
    }

    private List<Object> getParameters(Method method, Map<String, Serializable> userParameters) {
        Parameter[] methodParameters;
        ArrayList<Object> paramsToReturn = new ArrayList<Object>();
        for (Parameter methodParam : methodParameters = method.getParameters()) {
            String name = methodParam.getName();
            Object value = userParameters.get(name);
            if (value != null) {
                Class<?> typeClazz = methodParam.getType();
                value = this.getType(typeClazz, value);
                paramsToReturn.add(value);
                continue;
            }
            paramsToReturn.add(null);
        }
        return paramsToReturn;
    }

    private Object getType(Class<?> typeClazz, Object value) {
        if (!typeClazz.isAssignableFrom(value.getClass())) {
            String stringVal;
            Marshaller marshaller = this.injector.getInstance(Marshaller.class);
            if (value instanceof String) {
                stringVal = (String)value;
                if (typeClazz.isEnum()) {
                    value = Enum.valueOf(typeClazz, stringVal);
                    stringVal = null;
                }
            } else {
                stringVal = marshaller.marshall(value, DescriptorType.JSON);
            }
            if (stringVal != null) {
                value = marshaller.unmarshall(stringVal, typeClazz, DescriptorType.JSON);
            }
        }
        return value;
    }

    private JobToken decryptToken(String token) {
        String tokenJson = new ContentCrypto().decrypt(token);
        JobToken jobToken = this.injector.getInstance(Marshaller.class).unmarshall(tokenJson, JobToken.class, DescriptorType.JSON);
        return jobToken;
    }

    public JobPool getPool() {
        return this.pool;
    }

    @Inject
    public void setPool(JobPool pool) {
        this.pool = pool;
    }
}

