/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.request;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.FileUtils;
import org.appops.core.mime.MimeType;
import org.appops.core.response.Blob;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.log.service.slim.service.Level;
import org.appops.logging.logger.Logger;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.exception.InvocationException;
import org.appops.service.invocation.OperationInvoker;
import org.appops.service.request.RestResponseWriter;
import org.appops.slim.base.api.ServiceMetaManager;

@WebFilter(asyncSupported=true)
public class ServiceApiFilter
implements Filter {
    @Inject
    private Provider<OperationInvoker> invoker;
    @Inject
    private Provider<RestResponseWriter> responseWriter;
    @Inject
    private Logger logger;
    @Inject
    private Marshaller marshaller;
    private static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    static final String RESPONSE_TYPE_PARAMETER = "RESPONSE_TYPE";
    static final String HEAD_REQUEST = "HEAD_REQUEST";
    private File file = null;
    @Inject
    private ServiceMetaManager serviceMetaManager;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        HttpServletResponse httpServletResp = (HttpServletResponse)response;
        if (RequestMethod.POST.name().equals(httpServletReq.getMethod())) {
            httpServletReq.setAttribute(MULTIPART_CONFIG_ELEMENT, new MultipartConfigElement("", 0x3200000L, 0x3200000L, 0x6400000));
        }
        boolean isAsyncServiceOperation = false;
        String reqestUrl = httpServletReq.getRequestURI();
        ServiceMeta serviceMeta = this.getServiceMetaFromUrl(reqestUrl);
        if (serviceMeta != null) {
            isAsyncServiceOperation = this.checkAsyncServiceOp(reqestUrl);
        }
        if (httpServletReq.isAsyncSupported() && isAsyncServiceOperation) {
            try {
                RequestScoper scope = ServletScopes.transferRequest();
                try (RequestScoper.CloseableScope ignored = scope.open();){
                    String opRemovedUrl = this.replaceOpFromUrl(reqestUrl);
                    if (serviceMeta != null) {
                        this.serveRequest(httpServletReq, httpServletResp, opRemovedUrl, serviceMeta);
                    } else {
                        try {
                            chain.doFilter(request, response);
                        }
                        catch (IOException | ServletException e) {
                            this.logger.withLevel(Level.SEVERE).withMessage("Exception occurred in doFilter():: " + e);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.withMessage("Exception in getAsyncContext():: " + e);
            }
        } else {
            String opRemovedUrl = this.replaceOpFromUrl(reqestUrl);
            if (serviceMeta != null) {
                this.serveRequest(httpServletReq, httpServletResp, opRemovedUrl, serviceMeta);
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    private boolean checkAsyncServiceOp(String requestURI) {
        if (requestURI.equals("/") || requestURI.isEmpty()) {
            return false;
        }
        String reqUri = this.replaceOpFromUrl(requestURI);
        String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
        String opPathOrSignature = serviceAndPathArr[1];
        ServiceOpMeta serviceOpMeta = this.serviceMetaManager.getOpMeta(opPathOrSignature);
        boolean isAsyncOperation = serviceOpMeta.isAsyncFlag();
        return isAsyncOperation;
    }

    private void serveRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri, ServiceMeta serviceMeta) {
        String requestedMethod = req.getMethod();
        if (RequestMethod.GET.name().equals(requestedMethod)) {
            this.doGetRequest(req, resp, reqUri);
        } else if (RequestMethod.POST.name().equals(requestedMethod)) {
            this.doPostRequest(req, resp, reqUri);
        } else if (RequestMethod.HEAD.name().equals(requestedMethod)) {
            this.doHeadRequest(req, resp, reqUri);
        } else if (RequestMethod.PATCH.name().equals(requestedMethod)) {
            this.doPatchRequest(req, resp, reqUri);
        } else if (RequestMethod.DELETE.name().equals(requestedMethod)) {
            this.doDeleteRequest(req, resp, reqUri);
        } else if (RequestMethod.PUT.name().equals(requestedMethod)) {
            this.doPutRequest(req, resp, reqUri);
        } else if (RequestMethod.OPTIONS.name().equals(requestedMethod)) {
            this.doOptionsRequest(req, resp, reqUri);
        }
    }

    private ServiceMeta getServiceMetaFromUrl(String requestURI) {
        String opFilteredUrl = this.replaceOpFromUrl(requestURI);
        String serviceName = this.getServiceNameFromReqUri(opFilteredUrl);
        ServiceMeta serviceMeta = null;
        if (serviceName != null && !serviceName.isEmpty()) {
            try {
                serviceMeta = this.serviceMetaManager.getServiceMeta(serviceName);
            }
            catch (Exception e) {
                this.logger.withMessage("No service meta found for " + serviceName + " getServiceMetaFromUrl():: " + e);
            }
        }
        return serviceMeta;
    }

    private String replaceOpFromUrl(String reqUri) {
        if (reqUri.contains("/Op/")) {
            reqUri = reqUri.replaceAll("/Op/", "/");
        }
        return reqUri;
    }

    public void doGetRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        try {
            boolean hasFormData;
            String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
            Object result = this.invoker.get().invoke(serviceAndPathArr[0], serviceAndPathArr[1]);
            boolean bl = hasFormData = resp.getContentType() != null && !resp.getContentType().isEmpty() && resp.getContentType().toLowerCase().contains(((String)MimeType.MULTIPART.value()).toLowerCase());
            if (result != null) {
                this.responseWriter.get().sendResponse(resp, result, req.getParameter(RESPONSE_TYPE_PARAMETER));
            }
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : Arrays.toString(e.getStackTrace());
            this.sendErronInResponse(resp, 500, msg);
        }
    }

    public void doPostRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        boolean hasFormData = req.getContentType() != null && !req.getContentType().isEmpty() && req.getContentType().toLowerCase().contains(((String)MimeType.MULTIPART.value()).toLowerCase());
        try {
            String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
            OpParameterMap parameterMap = null;
            parameterMap = hasFormData ? this.convertFormDataToParamMap(req.getParts()) : this.unmarshallParameterMap(req);
            Object result = this.invoker.get().invoke(serviceAndPathArr[0], serviceAndPathArr[1], parameterMap);
            if (result != null) {
                this.responseWriter.get().sendResponse(resp, result, req.getParameter(RESPONSE_TYPE_PARAMETER));
            }
        }
        catch (Exception e) {
            this.sendErronInResponse(resp, 500, e.getMessage());
        }
    }

    protected void doDeleteRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        try {
            String[] serviceAndPathArr = this.extractServiceAndOpPath(reqUri);
            OpParameterMap parameterMap = null;
            parameterMap = this.unmarshallParameterMap(req);
            Object result = this.invoker.get().invoke(serviceAndPathArr[0], serviceAndPathArr[1], parameterMap);
            if (result != null) {
                this.responseWriter.get().sendResponse(resp, result, req.getParameter(RESPONSE_TYPE_PARAMETER));
            }
        }
        catch (Exception e) {
            this.sendErronInResponse(resp, 500, e.getMessage());
        }
    }

    protected void doHeadRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        this.doGetRequest(req, resp, reqUri);
    }

    protected void doPatchRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        this.doDeleteRequest(req, resp, reqUri);
    }

    protected void doPutRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        this.doDeleteRequest(req, resp, reqUri);
    }

    protected void doOptionsRequest(HttpServletRequest req, HttpServletResponse resp, String reqUri) {
        this.doGetRequest(req, resp, reqUri);
    }

    private String getServiceNameFromReqUri(String reqUri) {
        if (reqUri.startsWith("/")) {
            reqUri = reqUri.substring(1);
        }
        if (reqUri.contains(".html")) {
            int indexOfHtml = reqUri.indexOf(".html");
            reqUri = reqUri.substring(indexOfHtml + 5);
        } else if (reqUri.contains(".jsp")) {
            int indexOfJsp = reqUri.indexOf(".jsp");
            reqUri = reqUri.substring(indexOfJsp + 4);
        }
        if (reqUri.startsWith("/")) {
            reqUri = reqUri.substring(1);
        }
        String[] requestPathArr = reqUri.split("/");
        return requestPathArr[0];
    }

    public void sendErronInResponse(HttpServletResponse resp, int errorCode, String message) {
        try {
            if (message.contains("Invalid request :")) {
                errorCode = 400;
            }
            resp.sendError(errorCode, message);
        }
        catch (Exception ex) {
            this.logger.withLevel(Level.ERROR).withMessage(ex.toString()).log();
        }
    }

    private String[] extractServiceAndOpPath(String requestPath) {
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.isEmpty()) {
            this.throwRequestPatternException();
        }
        String[] requestPathArr = requestPath.split("/", 2);
        return requestPathArr;
    }

    public void throwRequestPatternException() {
        throw new InvocationException("Invalid request : minimum required pattern is /Op/<service_name>/<operation_info> An operation_info can be name or path of an operation.");
    }

    void setResponseWriter(Provider<RestResponseWriter> responseWriter) {
        this.responseWriter = responseWriter;
    }

    void setInvoker(Provider<OperationInvoker> invoker) {
        this.invoker = invoker;
    }

    void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    private OpParameterMap convertFormDataToParamMap(Collection<Part> parts) throws IOException {
        OpParameterMap parameterMap = new OpParameterMap();
        int order = 0;
        for (Part part : parts) {
            Blob blob = new Blob();
            blob.setInputStream(part.getInputStream());
            blob.setSize(part.getSize());
            blob.setMimeType(part.getContentType());
            blob.setNameOfFile(part.getSubmittedFileName());
            parameterMap.addParameter(order++, part.getName(), blob);
        }
        return parameterMap;
    }

    public File convertPartToFile(Part part) {
        File file = null;
        try {
            String path = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + "/src/main/resources/";
            String fileName = part.getName();
            file = new File(path + fileName);
            FileUtils.copyInputStreamToFile(part.getInputStream(), file);
            return file;
        }
        catch (Exception e) {
            throw new InvocationException(e.getMessage());
        }
    }

    private OpParameterMap unmarshallParameterMap(HttpServletRequest request) {
        StringBuilder jb = new StringBuilder();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            throw new InvocationException("Unable to read request data");
        }
        String data = jb.toString();
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            OpParameterMap parameterMap = this.marshaller.unmarshall(data, OpParameterMap.class, DescriptorType.JSON);
            return parameterMap;
        }
        catch (Exception e) {
            throw new InvocationException("Unable to unmarshall post request data.", e.getCause());
        }
    }

    @Override
    public void destroy() {
    }
}

