/*
 * Decompiled with CFR 0.152.
 */
package org.appops.web.jetty.server;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.URL;
import java.util.logging.Logger;
import org.appops.core.deployment.JettyConfig;
import org.appops.web.common.server.WebServer;
import org.appops.web.common.server.WebServerException;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyServer
extends WebServer<Server> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    public JettyServer(int port) {
        super(port, new Server(port));
    }

    public JettyServer connect() {
        try {
            ((Server)this.wrappedServer()).start();
        }
        catch (Exception e) {
            throw new WebServerException(e);
        }
        return this;
    }

    @Override
    public void disconnect() {
        try {
            ((Server)this.wrappedServer()).stop();
        }
        catch (Exception e) {
            throw new WebServerException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return ((Server)this.wrappedServer()).isRunning();
    }

    @Override
    public void configureAppContext(String contextPath, URL webappDirOrWarPath, String serviceName, JettyConfig jettyConfig) {
        WebAppContext context = new WebAppContext();
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebInfConfiguration(), new WebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new PlusConfiguration(), new JettyWebXmlConfiguration()});
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*");
        context.setContextPath(contextPath);
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*/[^/]*jstl.*\\.jar$");
        context.setAttribute("org.eclipse.jetty.server.Request.setAsyncSupported", true);
        if (webappDirOrWarPath.toString().endsWith(".war")) {
            context.setWar(webappDirOrWarPath.toString());
        } else {
            context.setBaseResource(JarResource.newResource(webappDirOrWarPath));
        }
        this.configureDefaultSessionIdManager(context, serviceName);
        this.addSqlSessionHandler(context, jettyConfig);
        ((Server)this.wrappedServer()).insertHandler(context);
    }

    public void configureDefaultSessionIdManager(WebAppContext context, String serviceName) {
        Server server = (Server)this.wrappedServer();
        DefaultSessionIdManager defaultSessionIdManager = new DefaultSessionIdManager(server);
        defaultSessionIdManager.setWorkerName(serviceName);
        server.setSessionIdManager(defaultSessionIdManager);
    }

    void addSqlSessionHandler(WebAppContext context, JettyConfig jettyConfig) {
        SessionHandler sessionHandler = context.getSessionHandler();
        DefaultSessionCache sessionCache = new DefaultSessionCache(sessionHandler);
        sessionCache.setSessionDataStore(this.getJdbcDataStoreFactory(jettyConfig.getDriver(), jettyConfig.getUrl(), jettyConfig.getUser(), jettyConfig.getPassword()).getSessionDataStore(sessionHandler));
        sessionHandler.setSessionCache(sessionCache);
        sessionHandler.setHttpOnly(true);
    }

    JDBCSessionDataStoreFactory getJdbcDataStoreFactory(String driver, String url, String user, String password) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDataSourceClassName(driver);
        hikariConfig.addDataSourceProperty("url", url);
        hikariConfig.addDataSourceProperty("user", user);
        hikariConfig.addDataSourceProperty("password", password);
        HikariDataSource datasources = new HikariDataSource(hikariConfig);
        DatabaseAdaptor databaseAdaptor = new DatabaseAdaptor();
        databaseAdaptor.setDriverInfo(driver, url);
        databaseAdaptor.setDatasource(datasources);
        JDBCSessionDataStoreFactory jdbcSessionDataStoreFactory = new JDBCSessionDataStoreFactory();
        jdbcSessionDataStoreFactory.setDatabaseAdaptor(databaseAdaptor);
        return jdbcSessionDataStoreFactory;
    }
}

