/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.strategicgains.util.date.DateAdapter;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import org.restexpress.serialization.json.GsonSerializer;

public class GsonDateSerializer
implements GsonSerializer<Date> {
    private DateAdapter adapter;

    public GsonDateSerializer() {
        this(new DateAdapter());
    }

    public GsonDateSerializer(DateAdapter adapter) {
        this.adapter = adapter;
    }

    public Date deserialize(JsonElement json, Type typeOf, JsonDeserializationContext context) throws JsonParseException {
        try {
            return this.adapter.parse(json.getAsJsonPrimitive().getAsString());
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public JsonElement serialize(Date date, Type typeOf, JsonSerializationContext context) {
        return new JsonPrimitive(this.adapter.format(date));
    }

    public Date createInstance(Type typeOf) {
        return new Date();
    }
}

