/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.lifecycle;

import org.appops.core.service.meta.ServiceOpMeta;

/**
 * Represents an service operation call/invocation.
 *
 * @author deba
 * @version $Id: $Id
 */
public class Call {
  private Call parent = null;

  private ServiceOpMeta operation = null;

  /**
   * <p>
   * Constructor for Call.
   * </p>
   *
   * @param op a {@link org.appops.core.service.meta.ServiceOpMeta} object.
   */
  public Call(ServiceOpMeta op) {
    this(op, null);
  }

  /**
   * Object constructor.
   *
   * @param op Invoked operation.
   * @param p Parent call.
   */
  public Call(ServiceOpMeta op, Call p) {
    parent = p;
    operation = op;
  }

  /**
   * <p>
   * Getter for the field <code>parent</code>.
   * </p>
   *
   * @return a {@link org.appops.service.lifecycle.Call} object.
   */
  public Call getParent() {
    return parent;
  }

  /**
   * <p>
   * Getter for the field <code>operation</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.meta.ServiceOpMeta} object.
   */
  public ServiceOpMeta getOperation() {
    return operation;
  }
}
