/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.store.api;

import org.appops.core.service.RequestMethod;
import org.appops.core.service.Service;
import org.appops.core.service.ServiceState;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.slim.base.core.ServiceStore;

/**
 * <p>
 * ServiceManager interface.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
@ServiceStore
public interface ServiceManager {


  /**
   * Registers new service.
   *
   * @param service Service to be registered.
   */
  @ServiceOp(path = "register", method = RequestMethod.POST)
  public void registerService(Service service);

  /**
   * Changes state of the service.
   *
   * @param serviceName Service whose state is to be changed.
   * @param newState New state for the service. e.g. STARTED,RUNNING etc.
   */
  @ServiceOp(path = "change-state", method = RequestMethod.POST)
  public void changeState(String serviceName, ServiceState newState);

  /**
   * Fetches already registered service by name.
   *
   * @param serviceName Name of the service to be looked for.
   * @return Fetched service instance.
   */
  @ServiceOp(path = "get/{serviceName}", method = RequestMethod.GET)
  public Service getService(String serviceName);

  /**
   * Checks if service with given name is already registered or not.
   *
   * @param serviceName Name of service to check.
   * @return Boolean value, true if service is already registered, false otherwise.
   */
  public boolean isRegistered(String serviceName);

}
