/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.entrypoint;

import java.io.File;
import java.util.HashMap;

/**
 * <p>
 * AppArgs class.
 * </p>
 *
 * @author deba
 * @version $Id: $Id
 */
@Deprecated
public class AppArgs extends HashMap<String, Object> {

  private static final String DepConfigPath = "deploymentConfig";

  /**
   * <p>
   * Constructor for AppArgs.
   * </p>
   */
  public AppArgs() {
    addDefaults();
  }

  /**
   * It reads the given arguments and return updated instance of
   * {@link org.appops.service.entrypoint.AppArgs}.
   *
   * @param args string array
   * @return instance of {@link org.appops.service.entrypoint.AppArgs}
   */
  public AppArgs readArgs(String[] args) {
    AppArgs appArgs = new AppArgs();
    if (args.length > 0) {
      int count = 0;
      while (count < args.length) {
        if (("--" + DepConfigPath).equals(args[count])) {
          appArgs.withDeploymentConfig(args[count + 1]);
          count = count + 2;
          continue;
        }
        count++;
      }
    }
    return appArgs;
  }



  private AppArgs withDeploymentConfig(String depConfigPath) {
    if (checkNullOrEmpty(depConfigPath)) {
      put(DepConfigPath, new File(depConfigPath));
    }
    return this;
  }

  /**
   * <p>
   * deploymentConfig.
   * </p>
   *
   * @return a {@link java.io.File} object.
   */
  public File deploymentConfig() {
    return (File) get(DepConfigPath);
  }

  private void addDefaults() {
    withDeploymentConfig("src/main/resources/dep.yml");
  }

  private boolean checkNullOrEmpty(Object value) {
    return (value != null && (value instanceof String ? !((String) value).isEmpty() : true));
  }
}
