/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import com.google.common.base.Strings;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveImageCmdExec
extends AbstrSyncDockerCmdExec<SaveImageCmd, InputStream>
implements SaveImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveImageCmdExec.class);

    public SaveImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected InputStream execute(SaveImageCmd command) {
        String name = command.getName();
        if (!Strings.isNullOrEmpty(command.getTag())) {
            name = name + ":" + command.getTag();
        }
        WebTarget webResource = this.getBaseResource().path("/images/" + name + "/get");
        LOGGER.trace("GET: {}", webResource);
        return webResource.request().accept(MediaType.APPLICATION_JSON).get();
    }
}

