/*
 * Decompiled with CFR 0.152.
 */
package org.appops.configuration.store;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import org.appops.configuration.generator.ConfigWrapper;
import org.appops.marshaller.DescriptorType;

public class ConfigurationStore {
    private static final String ENHANCER_BY_GUICE = "$$EnhancerByGuice";
    private static final String DEFAULT = "default";
    private Table<String, String, ConfigWrapper> configTable = HashBasedTable.create();

    public void addConfiguration(String className, String configuration) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        this.configTable.put(DEFAULT, className, new ConfigWrapper(configuration));
    }

    public void addConfiguration(String className, String configuration, DescriptorType descriptorType) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        this.configTable.put(DEFAULT, className, new ConfigWrapper(configuration, descriptorType));
    }

    public void addConfiguration(String serviceName, String className, String configuration) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        if (serviceName == null) {
            serviceName = DEFAULT;
        }
        this.configTable.put(serviceName, className, new ConfigWrapper(configuration));
    }

    public String getConfiguration(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map<String, ConfigWrapper> classConfigMap = this.configTable.column(className);
        for (Map.Entry<String, ConfigWrapper> entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return entry.getValue().getConfig();
        }
        return null;
    }

    public String getConfiguration(String serviceName, String className) {
        if (this.configTable.row(serviceName) != null && this.configTable.row(serviceName).get(className) != null) {
            return this.configTable.row(serviceName).get(className).getConfig();
        }
        return null;
    }

    public ConfigWrapper getConfigWrapper(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map<String, ConfigWrapper> classConfigMap = this.configTable.column(className);
        for (Map.Entry<String, ConfigWrapper> entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, ConfigWrapper> getConfigWrapperCollection(String className) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map<String, ConfigWrapper> classConfigMap = this.configTable.column(className);
        return classConfigMap;
    }

    public Map<String, ConfigWrapper> getAllServiceConfig(String serviceName) {
        return this.configTable.row(serviceName);
    }

    public boolean isConfigurationPresent(String className) {
        return this.configTable.containsColumn(className);
    }

    public ConfigWrapper getConfigWrapperByService(String className, String serviceName) {
        if (className.contains(ENHANCER_BY_GUICE)) {
            className = className.substring(0, className.indexOf(ENHANCER_BY_GUICE));
        }
        Map<String, ConfigWrapper> classConfigMap = this.configTable.column(className);
        for (Map.Entry<String, ConfigWrapper> entry : classConfigMap.entrySet()) {
            if (entry.getValue() == null || !entry.getKey().equals(serviceName)) continue;
            return entry.getValue();
        }
        return null;
    }
}

