/*
 * Decompiled with CFR 0.152.
 */
package org.appops.core;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appops.core.TypeScanner;
import org.appops.core.annotation.ImplModule;
import org.appops.core.annotation.SlimModule;
import org.reflections.Reflections;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.util.FilterBuilder;

public class ClassPathAnalyser {
    private TypeScanner typeScanner;
    private Reflections reflections;
    private List<String> defaultPackages = new ArrayList<String>();

    public ClassPathAnalyser() {
        this(null);
    }

    public ClassPathAnalyser(ClassLoader loader, String ... packages) {
        HashSet<Object> scanners = new HashSet<Object>(Arrays.asList(new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodParameterScanner(), new MethodParameterNamesScanner(), new TypeElementsScanner(), new SubTypesScanner(), new MethodAnnotationsScanner()));
        if (loader != null) {
            scanners.add((AbstractScanner)((Object)loader));
        }
        this.reflections = this.createReflections(scanners, Arrays.asList(packages));
    }

    public ClassPathAnalyser(String packageRef) {
        HashSet<Object> scanners = new HashSet<Object>(Arrays.asList(new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new MethodParameterScanner(), new MethodParameterNamesScanner(), new TypeElementsScanner(), new SubTypesScanner(), new MethodAnnotationsScanner()));
        this.reflections = this.createReflections(scanners, packageRef);
    }

    private Reflections createReflections(Set<Object> scanners, String packageRef) {
        this.defaultPackages.add("org.appops");
        this.defaultPackages.add("com.ainosoft");
        if (packageRef != null && !packageRef.isEmpty()) {
            this.defaultPackages.add(packageRef);
        }
        FilterBuilder filters = new FilterBuilder();
        for (String packagePrefix : this.defaultPackages) {
            filters.include(FilterBuilder.prefix(packagePrefix));
        }
        return new Reflections(scanners, filters);
    }

    private Reflections createReflections(Set<Object> scanners, List<String> packages) {
        this.defaultPackages.add("org.appops");
        this.defaultPackages.add("com.ainosoft");
        if (packages != null && !packages.isEmpty()) {
            this.defaultPackages.addAll(packages);
        }
        FilterBuilder filters = new FilterBuilder();
        for (String packagePrefix : this.defaultPackages) {
            filters.include(FilterBuilder.prefix(packagePrefix));
        }
        return new Reflections(scanners, filters);
    }

    public Set<Class<?>> getAnnotatedTypes(Class<? extends Annotation> annotation) {
        return this.reflections.getTypesAnnotatedWith(annotation);
    }

    public Map<String, Set<Class<? extends Module>>> getSlimModuleAnnotatedTypeMap() {
        Set<Class<?>> configClasses = this.getAnnotatedTypes(SlimModule.class);
        HashMap<String, Set<Class<? extends Module>>> map = new HashMap<String, Set<Class<? extends Module>>>();
        for (Class<?> annotatedClass : configClasses) {
            if (annotatedClass.getAnnotation(SlimModule.class) == null) continue;
            String ServiceName = annotatedClass.getAnnotation(SlimModule.class).serviceName().getCanonicalName();
            if (map.get(ServiceName) == null) {
                HashSet list = new HashSet();
                list.add(annotatedClass);
                map.put(ServiceName, list);
                continue;
            }
            ((Set)map.get(ServiceName)).add(annotatedClass);
        }
        return map;
    }

    public Map<String, Set<Class<? extends Module>>> getImplModuleAnnotatedTypeMap() {
        Set<Class<?>> configClasses = this.getAnnotatedTypes(ImplModule.class);
        HashMap<String, Set<Class<? extends Module>>> map = new HashMap<String, Set<Class<? extends Module>>>();
        for (Class<?> annotatedClass : configClasses) {
            if (annotatedClass.getAnnotation(ImplModule.class) == null) continue;
            String ServiceName = annotatedClass.getAnnotation(ImplModule.class).serviceName().getCanonicalName();
            if (map.get(ServiceName) == null) {
                HashSet list = new HashSet();
                list.add(annotatedClass);
                map.put(ServiceName, list);
                continue;
            }
            ((Set)map.get(ServiceName)).add(annotatedClass);
        }
        return map;
    }

    public List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> methodAnnotation) {
        return this.getTypeScanner().getAnnotatedMethods(clazz, methodAnnotation);
    }

    public TypeScanner getTypeScanner() {
        return this.typeScanner;
    }

    @Inject
    public void setTypeScanner(TypeScanner typeScanner) {
        this.typeScanner = typeScanner;
    }

    public <T> Collection<Class<? extends T>> subTypesOf(Class<T> superType) {
        return this.reflections.getSubTypesOf(superType);
    }
}

