/*
 * Decompiled with CFR 0.152.
 */
package org.appops.logging.impl;

import com.google.inject.Inject;
import org.appops.core.annotation.Config;
import org.appops.log.service.slim.service.Level;
import org.appops.log.service.slim.service.LogMeta;
import org.appops.log.service.slim.service.LogServiceManager;
import org.appops.logging.logger.Logger;
import org.appops.logging.logger.config.LoggerConfig;

public class ServiceLogger
implements Logger {
    private LogMeta meta;
    private LoggerConfig serviceLoggerConfig;
    public String loggerClassName;
    private LogServiceManager logServiceManager;

    @Override
    public Logger withLevel(Level level) {
        this.getMeta().addAttribute((String)LogMeta.LEVEL.value(), (Object)level);
        return this;
    }

    public boolean isEnabled(Level level) {
        Level enabledLevel = this.getServiceLoggerConfig().getLevel();
        return !Level.OFF.equals((Object)enabledLevel);
    }

    @Override
    public Logger withMessage(String message) {
        this.getMeta().addAttribute((String)LogMeta.MESSAGE.value(), message);
        return this;
    }

    @Override
    public Logger withMeta(LogMeta meta) {
        this.setMeta(meta);
        return this;
    }

    @Override
    public Logger withMeta(String key, Object value) {
        this.getMeta().addAttribute(key, value);
        return this;
    }

    @Override
    public boolean log() {
        Level level = (Level)((Object)this.getMeta().getAttributeValue((String)LogMeta.LEVEL.value()));
        String message = (String)this.getMeta().getAttributeValue((String)LogMeta.MESSAGE.value());
        this.getLogServiceManager().addLogRecord(this.getMeta());
        this.setMeta(null);
        return true;
    }

    public LogMeta getMeta() {
        if (this.meta == null) {
            this.meta = new LogMeta();
            if (this.loggerClassName != null) {
                this.meta.addAttribute((String)LogMeta.LOGGERNAME.value(), this.loggerClassName);
            }
        }
        return this.meta;
    }

    public void setMeta(LogMeta meta) {
        this.meta = meta;
    }

    public LoggerConfig getServiceLoggerConfig() {
        return this.serviceLoggerConfig;
    }

    @Inject
    public void setServiceLoggerConfig(@Config LoggerConfig serviceLoggerConfig) {
        this.serviceLoggerConfig = serviceLoggerConfig;
    }

    @Override
    public Logger setLoggerName(String loggerName) {
        this.loggerClassName = loggerName;
        return this;
    }

    public LogServiceManager getLogServiceManager() {
        return this.logServiceManager;
    }

    @Inject
    public void setLogServiceManager(LogServiceManager logServiceManager) {
        this.logServiceManager = logServiceManager;
    }
}

