/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.invocation;

import java.util.Set;
import org.appops.core.ClassPathAnalyser;
import org.appops.core.TypeScanner;
import org.appops.core.annotation.AsyncOf;

public class FindAyncImplementation {
    private ClassPathAnalyser classPathAnalyser;

    public Class<?> getAsyncImplementation(Class<?> apiClass) {
        String packageName = apiClass.getPackage().getName();
        Set<Class<?>> interfaceList = this.getClassPathAnalyser(packageName).getAnnotatedTypes(AsyncOf.class);
        for (Class<?> clazz : interfaceList) {
            AsyncOf asyncOfAnnoration = clazz.getAnnotation(AsyncOf.class);
            Class syncClazz = asyncOfAnnoration.sync();
            String syncClazzName = syncClazz.getName();
            if (!apiClass.getName().equals(syncClazzName)) continue;
            return clazz;
        }
        return null;
    }

    public ClassPathAnalyser getClassPathAnalyser(String refPackage) {
        if (this.classPathAnalyser == null) {
            this.classPathAnalyser = new ClassPathAnalyser(refPackage);
            this.classPathAnalyser.setTypeScanner(new TypeScanner());
        }
        return this.classPathAnalyser;
    }
}

