/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.lifecycle;

import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.service.exception.InvocationException;
import org.appops.service.lifecycle.Call;

public class CallStack
extends Stack<Call> {
    private Exception exception;

    public void addOperation(ServiceOpMeta operation) {
        Call current = null;
        if (!this.isEmpty()) {
            current = this.getCurrentCall();
        }
        Call newCall = new Call(operation, current);
        this.push(newCall);
    }

    public ServiceMeta getServiceOfOrigin() {
        return this.getCallOfOrigin().getOperation().serviceMeta();
    }

    public String getServiceOfOriginName() {
        return this.getCallOfOrigin().getOperation().serviceName();
    }

    public ServiceMeta getCurrentService() {
        return this.getCurrentOperation().serviceMeta();
    }

    public String getCurrentServiceName() {
        return this.getCurrentOperation().serviceName();
    }

    public void callFinished() {
        try {
            this.pop();
        }
        catch (EmptyStackException ex) {
            throw new InvocationException(ex);
        }
    }

    protected Call getCaller() {
        if (this.getCurrentCall() == null) {
            throw new InvocationException("Caller not present in stack.");
        }
        return this.getCurrentCall().getParent();
    }

    public ServiceOpMeta getCallerOperation() {
        Call caller = this.getCaller();
        if (caller != null) {
            return caller.getOperation();
        }
        throw new InvocationException("Caller not present in stack.");
    }

    protected Call getCallOfOrigin() {
        Call serv = null;
        try {
            serv = (Call)this.firstElement();
        }
        catch (NoSuchElementException ex) {
            throw new InvocationException(ex);
        }
        return serv;
    }

    public Call getCurrentCall() {
        if (!this.isEmpty()) {
            return (Call)this.peek();
        }
        throw new InvocationException("Cannot fetch current call, stack is empty.");
    }

    public ServiceOpMeta getCurrentOperation() {
        return this.getCurrentCall().getOperation();
    }

    public ServiceOpMeta getOperationOfOrigin() {
        return this.getCallOfOrigin().getOperation();
    }

    public void failedWithException(Exception e) {
        this.exception = e;
    }

    public Exception getFailureCause() {
        return this.exception;
    }
}

