/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.slim.builder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.appops.core.annotation.Config;
import org.appops.core.deployment.DeploymentMode;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.slim.base.invocation.ApiProxyInvocationHandler;

public class ServiceSlimInvocationBuilder {
    private Class<?> apiClass;
    private HashMap<String, String> headerMap = new HashMap();
    private ServiceConfiguration serviceConfiguration;
    @Inject
    private Injector injector;
    @Inject
    private ApiProxyInvocationHandler proxyInvocationHandler;

    public ServiceSlimInvocationBuilder getServiceInstance(Class<?> apiClass) {
        this.apiClass = apiClass;
        return this;
    }

    public ServiceSlimInvocationBuilder addHeader(String key, String value) {
        this.headerMap.put(key, value);
        return this;
    }

    public <T> Object build() {
        DeploymentMode deploymentMode = this.getServiceConfiguration().getMode();
        if (deploymentMode.equals((Object)DeploymentMode.STANDALONE)) {
            this.proxyInvocationHandler.getApiRestInvoker().getHttpHeader().getHeaderMap().putAll(this.headerMap);
            return this.createProxyForApiClass(this.apiClass);
        }
        if (deploymentMode.equals((Object)DeploymentMode.CLUBBED)) {
            return this.injector.getInstance(this.apiClass);
        }
        return null;
    }

    public <T> Object createProxyForApiClass(Class<T> apiClass) {
        return Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)this.proxyInvocationHandler);
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    @Inject
    public void setServiceConfiguration(@Config ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }
}

