/*
 * Decompiled with CFR 0.152.
 */
package org.appops.slim.base.invocation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collection;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.core.mime.MimeType;
import org.appops.core.response.Blob;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.Parameter;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.ServiceRoute;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.slim.base.api.ServiceMetaManager;
import org.appops.slim.base.exception.InvocationException;
import org.appops.slim.base.invocation.UrlEncodeUtil;
import org.appops.web.common.client.HttpHeader;
import org.appops.web.common.client.MultiPartData;
import org.appops.web.common.client.ServerResponse;
import org.appops.web.common.client.WebClient;

public class ApiRestInvoker {
    private Provider<ServiceConfiguration> currentDeployment;
    private Provider<WebClient> webClient;
    private Marshaller marshaller;
    private Provider<ServiceMetaManager> serviceStore;
    @Inject
    private HttpHeader httpHeader;

    public Object invokeRest(ServiceOpMeta opMeta) {
        try {
            Object parameters;
            String restUrl = this.getBaseRestUrl(opMeta);
            WebClient webClient = this.getWebClient();
            ServerResponse serverResponse = null;
            if (RequestMethod.GET.equals(opMeta.getMethod())) {
                restUrl = this.buildUrl(restUrl, opMeta, true);
                parameters = this.createParameterJson(opMeta.getParameters());
                serverResponse = webClient.get(restUrl, parameters, MimeType.JSON, null, this.httpHeader);
            } else if (RequestMethod.POST.equals(opMeta.getMethod())) {
                restUrl = this.buildUrl(restUrl, opMeta, false);
                parameters = this.createParameterJson(opMeta.getParameters());
                serverResponse = webClient.post(restUrl, parameters, MimeType.JSON, null, this.httpHeader);
            } else {
                throw new InvocationException("No request method provided in operation meta, please provide - GET/POST");
            }
            if (serverResponse.getStatus() != 200) {
                throw new InvocationException("Rest invocation failed, url -> " + restUrl + ", error code -> " + serverResponse.getStatus());
            }
            String responseText = serverResponse.getContentAsString();
            if (responseText == null || responseText.isEmpty()) {
                return "";
            }
            return this.convertResult(responseText, opMeta.getResultTypeName());
        }
        catch (Exception e) {
            throw e instanceof InvocationException ? (InvocationException)e : new InvocationException(e);
        }
    }

    private String getBaseRestUrl(ServiceOpMeta opMeta) {
        String deploymentUrl = this.getCurrentDeployment().getGatewayUrl();
        if (opMeta.serviceName().equals("ServiceStore")) {
            return this.getCurrentDeployment().getGatewayUrl();
        }
        ServiceRoute serviceRoute = this.getServiceStore().getServiceRoute(opMeta.serviceName());
        String serviceUrl = serviceRoute != null ? serviceRoute.getServiceUrl() : "";
        return serviceUrl != null && !serviceUrl.isEmpty() ? serviceUrl : deploymentUrl;
    }

    private Object createParameterJson(OpParameterMap parameters) {
        long match = parameters.entrySet().stream().filter(e -> ((Parameter)e.getValue()).getTypeName().equals(Blob.class.getCanonicalName())).count();
        if (match > 0L && this.getCurrentDeployment().getAppopsBlobUpload().booleanValue()) {
            MultiPartData data = new MultiPartData();
            for (Integer order : parameters.keySet()) {
                Parameter param = (Parameter)parameters.get(order);
                data.addField(order.toString(), param);
            }
            return data;
        }
        return this.marshaller.marshall(parameters, DescriptorType.JSON);
    }

    private Object convertResult(String contentAsString, String resultTypename) {
        if (String.class.getCanonicalName().equals(resultTypename)) {
            return contentAsString;
        }
        Class<?> resultType = null;
        try {
            resultType = Class.forName(resultTypename);
        }
        catch (Exception e) {
            throw new InvocationException("Error while converting rest call result", e);
        }
        return this.getMarshaller().unmarshall(contentAsString, resultType, DescriptorType.JSON);
    }

    public String buildUrl(String restUrl, ServiceOpMeta opMeta, boolean appendParamters) {
        if (!restUrl.endsWith("/")) {
            restUrl = restUrl + "/";
        }
        if (opMeta.serviceName() == null || opMeta.serviceName().isEmpty()) {
            throw new InvocationException("Parent service name is null, please provide it through service op meta instance passed.");
        }
        restUrl = restUrl + opMeta.serviceName();
        Collection<Parameter> params = opMeta.getParameters().values();
        String friendly = opMeta.getFriendly();
        String name = opMeta.getName();
        String path = opMeta.getPath();
        if (path != null && !path.isEmpty()) {
            restUrl = restUrl + "/" + this.evaluatePathParameters(path, opMeta);
        } else if (friendly != null && !friendly.isEmpty()) {
            restUrl = restUrl + "/" + friendly;
        } else if (name != null && !name.isEmpty()) {
            restUrl = restUrl + "/" + name;
        } else {
            throw new InvocationException("Both signature and friendly cannot be null for an operation =>" + opMeta.getName() + ", Service => " + opMeta.serviceName());
        }
        if (appendParamters) {
            restUrl = restUrl + this.addRequestParameters(params);
        }
        System.out.println("ApiRestInvoker url - > " + restUrl);
        return restUrl;
    }

    private String evaluatePathParameters(String path, ServiceOpMeta opMeta) {
        UrlEncodeUtil parameterEncoder = new UrlEncodeUtil();
        if (path != null && path.contains("/")) {
            String[] pathElements = path.split("/");
            for (int i = 0; i < pathElements.length; ++i) {
                String parameterPart;
                String parameterName;
                Parameter parameter;
                String pathElement = pathElements[i];
                if (!pathElement.startsWith("{") || !pathElement.endsWith("}") || (parameter = opMeta.getParameter(parameterName = (parameterPart = pathElement.substring(pathElement.indexOf("{"), pathElement.indexOf("}") + 1).trim()).substring(parameterPart.indexOf("{") + 1, parameterPart.indexOf("}")))) == null) continue;
                path = path.replace(parameterPart, parameterEncoder.encodePathParam(parameter.getValue().toString()));
            }
        }
        return path;
    }

    private String addRequestParameters(Collection<Parameter> params) {
        String parameterPart = "";
        if (!params.isEmpty()) {
            parameterPart = parameterPart + "?";
        }
        for (Parameter parameter : params) {
            if (!parameterPart.endsWith("?") && !parameterPart.endsWith("&")) {
                parameterPart = parameterPart + "&";
            }
            parameterPart = parameterPart + parameter.getName() + "=" + parameter.getValue();
        }
        return parameterPart;
    }

    public ServiceConfiguration getCurrentDeployment() {
        return this.currentDeployment.get();
    }

    @Inject
    public void setCurrentDeployment(@Named(value="CURRENT_DEPLOYMENT") Provider<ServiceConfiguration> currentDeployment) {
        this.currentDeployment = currentDeployment;
    }

    public WebClient getWebClient() {
        return this.webClient.get();
    }

    @Inject
    public void setWebClient(Provider<WebClient> webClient) {
        this.webClient = webClient;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public ServiceMetaManager getServiceStore() {
        return this.serviceStore.get();
    }

    @Inject
    public void setServiceStore(Provider<ServiceMetaManager> serviceStore) {
        this.serviceStore = serviceStore;
    }

    public HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    @Inject
    public void setHttpHeader(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }
}

