/*
 * Decompiled with CFR 0.152.
 */
package org.appops.slim.base.invocation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.slim.base.exception.InvocationException;
import org.appops.slim.base.invocation.ApiProxyInvocationHandler;

public class DerivedApiProxyInvocationHandler
extends ApiProxyInvocationHandler {
    private String serviceName;
    private String interfaceName;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ServiceOpMeta opMeta = this.createOpMeta(method, args);
        return this.getApiRestInvoker().invokeRest(opMeta);
    }

    @Override
    public ServiceOpMeta createOpMeta(Method method, Object[] args) {
        ServiceOpMeta opMeta = new ServiceOpMeta();
        opMeta.setName(method.getName());
        ServiceOp opAnnotation = method.getAnnotation(ServiceOp.class);
        if (opAnnotation == null) {
            throw new InvocationException("Cannot invoke operation, ServiceOp annotation is absent on method ->" + method.getName());
        }
        opMeta.setFriendly(opAnnotation.friendly());
        opMeta.setPath(opAnnotation.path());
        opMeta.setResultTypeName(method.getReturnType().getCanonicalName());
        opMeta.setMethod(opAnnotation.method());
        Parameter[] parameters = method.getParameters();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                org.appops.core.service.Parameter parameter = new org.appops.core.service.Parameter(i, parameters[i].getName(), args[i]);
                parameter.setTypeName(method.getParameterTypes()[i].getCanonicalName());
                opMeta.addParameter(parameter);
            }
        }
        InterfaceMeta interfaceMeta = new InterfaceMeta();
        String inerfaceCanonicalName = this.interfaceName;
        interfaceMeta.setQualifiedClassName(inerfaceCanonicalName);
        interfaceMeta.setName(inerfaceCanonicalName.substring(inerfaceCanonicalName.lastIndexOf(46) + 1));
        opMeta.setParent(interfaceMeta);
        interfaceMeta.addOperation(opMeta);
        String serviceName = this.serviceName;
        if (serviceName == null) {
            throw new InvocationException("Cannot invoke operation, unable to locate service name for method ->" + method.getName());
        }
        ServiceMeta serviceMeta = new ServiceMeta(serviceName);
        interfaceMeta.setParent(serviceMeta);
        return opMeta;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }
}

