/*
 * Decompiled with CFR 0.152.
 */
package org.appops.slim.base.invocation;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.appops.slim.base.exception.InvocationException;

public class UrlEncodeUtil {
    private static final String forwardSlash = "$SLASH$";
    private Map<String, String> charReplacementMap = new HashMap<String, String>();

    public UrlEncodeUtil() {
        this.charReplacementMap.put("/", forwardSlash);
    }

    public String encodePathParam(String parameter) {
        for (String key : this.charReplacementMap.keySet()) {
            parameter = parameter.contains(key) ? parameter.replaceAll(key, this.urlEncode(this.charReplacementMap.get(key))) : parameter;
        }
        return parameter;
    }

    public String decodePathParam(String parameter) {
        parameter = this.urlDecode(parameter);
        for (String key : this.charReplacementMap.keySet()) {
            while (parameter.contains(this.charReplacementMap.get(key))) {
                parameter = parameter.replace(this.charReplacementMap.get(key), key);
            }
        }
        return parameter;
    }

    public String urlEncode(String url) {
        try {
            String encoded = URLEncoder.encode(url, "UTF-8");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvocationException(e);
        }
    }

    public String urlDecode(String encoded) {
        try {
            String decoded = URLDecoder.decode(encoded, "UTF-8");
            return decoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvocationException(e);
        }
    }
}

