/*
 * Decompiled with CFR 0.152.
 */
package org.appops.slim.base.invocation.async;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.appops.core.annotation.AsyncOf;
import org.appops.core.service.annotation.Service;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.slim.base.exception.InvocationException;

public class AsyncOpMetaComputer {
    public ServiceOpMeta computeOpMeta(Method method, Object[] args) throws NoSuchMethodException, SecurityException {
        ServiceOpMeta opMeta = new ServiceOpMeta();
        opMeta.setName(method.getName());
        Class<?> asyncOfClass = method.getDeclaringClass();
        AsyncOf asyncOfAnnoration = asyncOfClass.getAnnotation(AsyncOf.class);
        Class syncClazz = asyncOfAnnoration.sync();
        Method syncMethod = syncClazz.getMethod(method.getName(), method.getParameterTypes());
        ServiceOp opAnnotation = syncMethod.getAnnotation(ServiceOp.class);
        if (opAnnotation == null) {
            throw new InvocationException("Cannot invoke operation, ServiceOp annotation is absent on method ->" + syncMethod.getName());
        }
        opMeta.setFriendly(opAnnotation.friendly());
        opMeta.setPath(opAnnotation.path());
        opMeta.setResultTypeName(syncMethod.getReturnType().getCanonicalName());
        opMeta.setMethod(opAnnotation.method());
        opMeta.setAsyncFlag(opAnnotation.async());
        Parameter[] parameters = syncMethod.getParameters();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                org.appops.core.service.Parameter parameter = new org.appops.core.service.Parameter(i, parameters[i].getName(), args[i]);
                parameter.setTypeName(syncMethod.getParameterTypes()[i].getCanonicalName());
                opMeta.addParameter(parameter);
            }
        }
        InterfaceMeta interfaceMeta = new InterfaceMeta();
        interfaceMeta.setName(syncMethod.getDeclaringClass().getSimpleName());
        interfaceMeta.setQualifiedClassName(syncMethod.getDeclaringClass().getCanonicalName());
        opMeta.setParent(interfaceMeta);
        interfaceMeta.addOperation(opMeta);
        String serviceName = null;
        for (Annotation annotation : syncMethod.getDeclaringClass().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Service.class)) continue;
            serviceName = annotation.annotationType().getSimpleName();
            break;
        }
        if (serviceName == null) {
            throw new InvocationException("Cannot invoke operation, unable to locate service name for method ->" + syncMethod.getName());
        }
        ServiceMeta serviceMeta = new ServiceMeta(serviceName);
        interfaceMeta.setParent(serviceMeta);
        return opMeta;
    }
}

