/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class PipelineInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 20480;
    private List<ChannelHandler> requestHandlers = new ArrayList<ChannelHandler>();
    private int maxContentLength = 20480;
    private EventExecutorGroup eventExecutorGroup = null;
    private SSLContext sslContext = null;

    public PipelineInitializer addRequestHandler(ChannelHandler handler) {
        if (!this.requestHandlers.contains(handler)) {
            this.requestHandlers.add(handler);
        }
        return this;
    }

    public PipelineInitializer setExecutionHandler(EventExecutorGroup executorGroup) {
        this.eventExecutorGroup = executorGroup;
        return this;
    }

    public PipelineInitializer setMaxContentLength(int value) {
        this.maxContentLength = value;
        return this;
    }

    public PipelineInitializer setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (null != this.sslContext) {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(sslEngine);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
        this.addAllHandlers(pipeline);
    }

    private void addAllHandlers(ChannelPipeline pipeline) {
        if (this.eventExecutorGroup != null) {
            for (ChannelHandler handler : this.requestHandlers) {
                pipeline.addLast(this.eventExecutorGroup, handler.getClass().getSimpleName(), handler);
            }
        } else {
            for (ChannelHandler handler : this.requestHandlers) {
                pipeline.addLast(handler.getClass().getSimpleName(), handler);
            }
        }
    }
}

