/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.deployment;

import com.google.inject.Inject;
import java.io.IOException;
import org.appops.configuration.store.ConfigurationStore;
import org.appops.core.deployment.ServiceConfiguration;
import org.appops.marshaller.Marshaller;
import org.appops.service.exception.DeploymentException;
import org.appops.web.jetty.server.JettyContainer;

/**
 * Launcher class to configure and start embeded jetty server within an appops service.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ServiceJettyLauncher {

  // private AppServiceProvider serviceProvider;
  private Marshaller marshaller;
  private ConfigurationStore configurationStore;
  private JettyContainer jettyContainer;

  /**
   * Launches embedded jetty server for service application.
   *
   * @param serviceConfiguration contains embedded jetty server configuration.
   * @return true, if launched embedded jetty server otherwise false.
   */
  public boolean launch(ServiceConfiguration serviceConfiguration) {

    try {
      getJettyContainer().deployWebapp(serviceConfiguration.getWebConfig().getPort(),
          serviceConfiguration.getWebConfig().getContextPath(),
          serviceConfiguration.getWebappDirectory().toURI().toURL(),
          serviceConfiguration.getServiceName(), serviceConfiguration.getJettyConfig());
    } catch (IOException e) {
      throw new DeploymentException(e);
    }
    return true;

  }


  // public AppServiceProvider getServiceProvider() {
  // return serviceProvider;
  // }
  //
  // @Inject
  // public void setServiceProvider(AppServiceProvider serviceProvider) {
  // this.serviceProvider = serviceProvider;
  // }

  /**
   * <p>
   * Getter for the field <code>marshaller</code>.
   * </p>
   *
   * @return a {@link org.appops.marshaller.Marshaller} object.
   */
  public Marshaller getMarshaller() {
    return marshaller;
  }

  /**
   * <p>
   * Setter for the field <code>marshaller</code>.
   * </p>
   *
   * @param marshaller a {@link org.appops.marshaller.Marshaller} object.
   */
  @Inject
  public void setMarshaller(Marshaller marshaller) {
    this.marshaller = marshaller;
  }


  /**
   * <p>
   * Getter for the field <code>configurationStore</code>.
   * </p>
   *
   * @return a {@link org.appops.configuration.store.ConfigurationStore} object.
   */
  public ConfigurationStore getConfigurationStore() {
    return configurationStore;
  }

  /**
   * <p>
   * Setter for the field <code>configurationStore</code>.
   * </p>
   *
   * @param configurationStore a {@link org.appops.configuration.store.ConfigurationStore} object.
   */
  @Inject
  public void setConfigurationStore(ConfigurationStore configurationStore) {
    this.configurationStore = configurationStore;
  }

  /**
   * <p>
   * Getter for the field <code>jettyContainer</code>.
   * </p>
   *
   * @return a {@link org.appops.web.jetty.server.JettyContainer} object.
   */
  public JettyContainer getJettyContainer() {
    return jettyContainer;
  }

  /**
   * <p>
   * Setter for the field <code>jettyContainer</code>.
   * </p>
   *
   * @param jettyContainer a {@link org.appops.web.jetty.server.JettyContainer} object.
   */
  @Inject
  public void setJettyContainer(JettyContainer jettyContainer) {
    this.jettyContainer = jettyContainer;
  }

}
