/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.store;

import java.util.HashMap;
import org.appops.core.job.JobMeta;
import org.appops.core.service.RequestMethod;
import org.appops.core.service.annotation.ServiceOp;
import org.appops.slim.base.core.ServiceStore;

/**
 * JobMetaRegistry which store all jobs in ServiceName vs JobClassName vs JobMeta in table format
 * and provide friendly operations to fetch.
 *
 * @author prashant
 * @version $Id: $Id
 */
@ServiceStore
public interface JobMetaRegistry {
  /**
   * Register {@link org.appops.core.job.JobMeta} in
   * {@link org.appops.service.store.JobMetaRegistry} store.
   *
   * @param jobKey qualified name of job class.
   * @param jobMeta meta information of job.
   */
  @ServiceOp(method = RequestMethod.POST, path = "registerJobMeta")
  public void registerJobMeta(String jobKey, JobMeta jobMeta);

  /**
   * Fetch {@link org.appops.core.job.JobMeta} information from store .
   *
   * @param jobKey qualified name of job class.
   * @return {@link org.appops.core.job.JobMeta} of provided service and job class.
   */

  @ServiceOp(method = RequestMethod.GET, path = "getJobMeta")
  public JobMeta getJobMeta(String jobKey);

  /**
   * Fetch all {@link org.appops.core.job.JobMeta} information of provided service.
   *
   * @return {@link java.util.HashMap} of {@link org.appops.core.job.JobMeta} .
   */
  @ServiceOp(method = RequestMethod.GET, path = "getAllJobMeta")
  public HashMap<String, JobMeta> getAllJobMeta();


}
