/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.impl.store;

import com.google.inject.Inject;
import org.appops.core.service.Service;
import org.appops.core.service.ServiceState;
import org.appops.service.store.ServiceRegistry;
import org.appops.service.store.api.ServiceManager;

public class ServiceManagerImpl implements ServiceManager {

  private ServiceRegistry serviceRegistry;

  @Inject
  public ServiceManagerImpl(ServiceRegistry serviceRegistry) {
    this.serviceRegistry = serviceRegistry;
  }

  @Override
  public void registerService(Service service) {
    serviceRegistry.register(service);
  }

  @Override
  public void changeState(String serviceName, ServiceState newState) {
    serviceRegistry.changeState(serviceName, newState);
  }

  @Override
  public Service getService(String serviceName) {
    return serviceRegistry.getService(serviceName);
  }

  @Override
  public boolean isRegistered(String serviceName) {
    return serviceRegistry.isRegistered(serviceName);
  }
}
