/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.impl;

import java.io.IOException;
import org.appops.core.ServiceException;
import org.appops.service.entrypoint.ServiceEntryPoint;


/**
 * Service store application entry point class.
 */
public class ServiceStoreService extends ServiceEntryPoint {
  /**
   * Service application entry point.
   * 
   * @param args Expects deployment configuration file (deployment.yml) path as an argument. e.g.
   *        java -jar app.jar --deploymentConfig deployment.yml
   * 
   * @throws IOException Input output exception which can be occurred while reading configuration
   *         file passed.
   * @throws ServiceException Service exception which can be occurred while running service.
   */
  public static void main(String[] args) throws IOException, ServiceException {
    new ServiceStoreService().startService(args);
  }

}
