/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.impl.store;

import java.util.HashMap;
import org.appops.core.job.JobMeta;
import org.appops.service.store.JobMetaRegistry;

public class JobMetaRegistryImpl implements JobMetaRegistry {
  private HashMap<String, JobMeta> jobMetaMap = new HashMap<String, JobMeta>();

  private HashMap<String, JobMeta> getJobMetaMap() {
    return jobMetaMap;
  }


  // implementations

  @Override
  public void registerJobMeta(String jobKey, JobMeta jobMeta) {
    getJobMetaMap().put(jobKey, jobMeta);
  }

  @Override
  public JobMeta getJobMeta(String jobKey) {
    return getJobMetaMap().get(jobKey);
  }

  @Override
  public HashMap<String, JobMeta> getAllJobMeta() {
    return getJobMetaMap();
  }


}
