/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.service.mock;

import org.appops.core.service.Parameter;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.service.impl.store.ServiceMetaRegistryImpl;

/**
 * Mock service meta registry.
 */
public class ServiceMetaMockRegistry extends ServiceMetaRegistryImpl {

  public ServiceMetaMockRegistry() {
    createMockData();
  }

  /**
   * Creates mock service metas.
   * 
   */
  public void createMockData() {

    // logger.log(Level.INFO, "create mock data");

    ServiceMeta serviceMeta1 = new ServiceMeta();
    serviceMeta1.setName("Entities");
    serviceMeta1.setId((long) 1);



    Parameter param1 = new Parameter();
    param1.setId((long) 1);
    param1.setName("typeName");
    param1.setTypeName("java.lang.String");
    param1.setOrder(0);

    Parameter param2 = new Parameter();
    param2.setId((long) 2);
    param2.setName("id");
    param2.setTypeName("java.io.Serializable");
    param2.setOrder(1);

    Parameter param3 = new Parameter();
    param3.setId((long) 3);
    param3.setName("q");
    param3.setTypeName("org.appops.altshared.shared.altcore.altentity.altquery.AltQuery");
    param3.setOrder(0);

    Parameter param4 = new Parameter();
    param4.setId((long) 4);
    param4.setName("string");
    param4.setTypeName("java.lang.String");
    param4.setOrder(0);

    Parameter param5 = new Parameter();
    param5.setId((long) 5);
    param5.setName("q");
    param5.setTypeName("org.appops.altshared.shared.altcore.altentity.altquery.AltQuery");
    param5.setOrder(0);

    Parameter param6 = new Parameter();
    param6.setId((long) 6);
    param6.setName("operationId");
    param6.setTypeName("org.appops.altshared.shared.altcore.altentity.AltLongId");
    param6.setOrder(0);

    Parameter param7 = new Parameter();
    param7.setId((long) 7);
    param7.setName("queryName");
    param7.setTypeName("java.lang.String");
    param7.setOrder(0);

    Parameter param8 = new Parameter();
    param8.setId((long) 8);
    param8.setName("queryString");
    param8.setTypeName("java.lang.String");
    param8.setOrder(0);

    InterfaceMeta interfMeta1 = new InterfaceMeta();
    interfMeta1.setName("Fetch");
    interfMeta1.setId((long) 1);
    interfMeta1.setParent(serviceMeta1);
    interfMeta1.lightweightCopy();

    ServiceOpMeta operation1 = new ServiceOpMeta();

    operation1.setName("getEntity");
    operation1.setId((long) 1);
    operation1.addParameter(param1);
    operation1.addParameter(param2);

    ServiceOpMeta operation2 = new ServiceOpMeta();

    operation2.setName("getPartialEntityList");
    operation2.setId((long) 2);
    operation2.addParameter(param3);

    ServiceOpMeta operation3 = new ServiceOpMeta();
    operation3.setName("getEntityList");
    operation3.setId((long) 3);
    operation3.addParameter(param4);

    InterfaceMeta interfMeta2 = new InterfaceMeta();
    interfMeta2.setName("BaseAppOpsServiceInterface");
    interfMeta2.setId((long) 2);
    interfMeta2.setParent(serviceMeta1);
    interfMeta2.lightweightCopy();

    InterfaceMeta interfMeta3 = new InterfaceMeta();
    interfMeta3.setName("ServiceStore");
    interfMeta3.setId((long) 3);
    interfMeta3.setParent(serviceMeta1);
    interfMeta3.lightweightCopy();

    ServiceOpMeta operation4 = new ServiceOpMeta();
    operation4.setName("getActiveServiceSet");
    operation4.setId((long) 4);
    operation4.addParameter(param5);

    ServiceOpMeta operation5 = new ServiceOpMeta();
    operation5.setName("getOperationById");
    operation5.setId((long) 5);

    InterfaceMeta interfMeta4 = new InterfaceMeta();
    interfMeta4.setName("Crud");
    interfMeta4.setId((long) 4);
    interfMeta4.setParent(serviceMeta1);
    interfMeta4.lightweightCopy();

    InterfaceMeta interfMeta5 = new InterfaceMeta();
    interfMeta5.setName("QueryEditor");
    interfMeta5.setId((long) 5);
    interfMeta5.setParent(serviceMeta1);
    interfMeta5.lightweightCopy();

    ServiceOpMeta operation6 = new ServiceOpMeta();
    operation6.setName("createQuery");
    operation6.setId((long) 6);
    operation6.addParameter(param6);



    ServiceOpMeta operation7 = new ServiceOpMeta();
    operation7.setName("deleteServiceQueries");
    operation7.setId((long) 7);
    operation7.addParameter(param7);
    operation7.addParameter(param8);

    InterfaceMeta interfMeta6 = new InterfaceMeta();
    interfMeta6.setName("Crud");
    interfMeta6.setId((long) 6);
    interfMeta6.setParent(serviceMeta1);
    interfMeta6.lightweightCopy();

    ServiceOpMeta operation8 = new ServiceOpMeta();
    operation8.setName("deleteEntityGraph");
    operation8.setId((long) 8);

    ServiceOpMeta operation9 = new ServiceOpMeta();
    operation9.setName("getEntity");
    operation9.setId((long) 9);

    ServiceOpMeta operation10 = new ServiceOpMeta();
    operation10.setName("saveEntity");
    operation10.setId((long) 10);

    ServiceOpMeta operation11 = new ServiceOpMeta();
    operation11.setName("saveUpdateEntityGraph");
    operation11.setId((long) 11);

    ServiceOpMeta operation12 = new ServiceOpMeta();
    operation12.setName("saveEntity");
    operation12.setId((long) 12);

    ServiceOpMeta operation13 = new ServiceOpMeta();
    operation13.setName("deleteEntity");
    operation13.setId((long) 13);

    InterfaceMeta interfMeta7 = new InterfaceMeta();
    interfMeta7.setName("SchemaEditor");
    interfMeta7.setId((long) 7);
    interfMeta7.setParent(serviceMeta1);
    interfMeta7.lightweightCopy();

    serviceMeta1.addInterface(interfMeta1);
    serviceMeta1.addInterface(interfMeta2);
    serviceMeta1.addInterface(interfMeta3);
    serviceMeta1.addInterface(interfMeta4);
    serviceMeta1.addInterface(interfMeta5);
    serviceMeta1.addInterface(interfMeta6);
    serviceMeta1.addInterface(interfMeta7);

    interfMeta1.addOperation(operation1);
    interfMeta1.addOperation(operation2);
    interfMeta1.addOperation(operation3);

    interfMeta3.addOperation(operation4);
    interfMeta3.addOperation(operation5);

    interfMeta5.addOperation(operation6);
    interfMeta5.addOperation(operation7);

    interfMeta6.addOperation(operation8);
    interfMeta6.addOperation(operation9);
    interfMeta6.addOperation(operation10);
    interfMeta6.addOperation(operation11);
    interfMeta6.addOperation(operation12);
    interfMeta6.addOperation(operation13);

    //////////////////////////////////////////////////



    Parameter param9 = new Parameter();
    param9.setId((long) 9);
    param9.setName("operation");
    param9.setTypeName("org.appops.altshared.shared.altdto.AltService");
    param9.setOrder(0);

    Parameter param10 = new Parameter();
    param10.setId((long) 10);
    param10.setName("q");
    param10.setTypeName("org.appops.altshared.shared.altcore.altentity.altquery.AltQuery");
    param10.setOrder(0);

    Parameter param11 = new Parameter();
    param11.setId((long) 5);
    param11.setName("id");
    param11.setTypeName("java.io.Serializable");
    param11.setOrder(0);

    ServiceOpMeta operation14 = new ServiceOpMeta();
    operation14.setName("getAllActionables");
    operation14.setId((long) 14);
    operation14.addParameter(param9);

    ServiceOpMeta operation15 = new ServiceOpMeta();
    operation15.setName("getFormActionables");
    operation15.setId((long) 15);
    operation15.addParameter(param10);

    ServiceOpMeta operation16 = new ServiceOpMeta();
    operation16.setName("getListActionables");
    operation16.setId((long) 16);
    operation16.addParameter(param11);

    ServiceMeta serviceMeta2 = new ServiceMeta();
    serviceMeta2.setName("Services");
    serviceMeta2.setId((long) 2);

    InterfaceMeta interfMeta21 = new InterfaceMeta();
    interfMeta21.setName("ServiceStore");
    interfMeta21.setId((long) 8);
    interfMeta21.setParent(serviceMeta2);
    interfMeta21.lightweightCopy();

    InterfaceMeta interfMeta22 = new InterfaceMeta();
    interfMeta22.setName("ActionableProvider");
    interfMeta22.setId((long) 9);
    interfMeta22.setParent(serviceMeta2);
    interfMeta22.lightweightCopy();

    InterfaceMeta interfMeta23 = new InterfaceMeta();
    interfMeta23.setName("ServiceEditor");
    interfMeta23.setId((long) 10);
    interfMeta23.setParent(serviceMeta2);
    interfMeta23.lightweightCopy();

    InterfaceMeta interfMeta24 = new InterfaceMeta();
    interfMeta24.setName("BaseAppOpsServiceInterface");
    interfMeta24.setId((long) 11);
    interfMeta24.setParent(serviceMeta2);
    interfMeta24.lightweightCopy();

    serviceMeta2.addInterface(interfMeta21);
    serviceMeta2.addInterface(interfMeta22);
    serviceMeta2.addInterface(interfMeta23);
    serviceMeta2.addInterface(interfMeta24);

    ////////////////////////////////////////////////////

    ServiceMeta serviceMeta3 = new ServiceMeta();
    serviceMeta3.setName("Users");
    serviceMeta3.setId((long) 3);

    InterfaceMeta interfMeta31 = new InterfaceMeta();
    interfMeta31.setName("BaseAppOpsServiceInterface");
    interfMeta31.setId((long) 12);
    interfMeta31.setParent(serviceMeta3);
    interfMeta31.lightweightCopy();

    InterfaceMeta interfMeta32 = new InterfaceMeta();
    interfMeta32.setName("UserService");
    interfMeta32.setId((long) 13);
    interfMeta32.setParent(serviceMeta3);
    interfMeta32.lightweightCopy();

    serviceMeta3.addInterface(interfMeta31);
    serviceMeta3.addInterface(interfMeta32);

    ////////////////////////////////////////////////////

    ServiceMeta serviceMeta4 = new ServiceMeta();
    InterfaceMeta interfMeta41 = new InterfaceMeta();


    serviceMeta4.setName("Spaces");
    serviceMeta4.setId((long) 4);

    interfMeta41.setName("SpaceService");
    interfMeta41.setId((long) 14);
    interfMeta41.setParent(serviceMeta4);
    interfMeta41.lightweightCopy();

    InterfaceMeta interfMeta42 = new InterfaceMeta();
    interfMeta42.setName("BaseAppOpsServiceInterface");
    interfMeta42.setId((long) 15);
    interfMeta42.setParent(serviceMeta4);
    interfMeta42.lightweightCopy();

    serviceMeta4.addInterface(interfMeta41);
    serviceMeta4.addInterface(interfMeta42);

    /////////////////////////////////////////////////////

    ServiceMeta serviceMeta5 = new ServiceMeta();
    serviceMeta5.setId((long) 5);
    serviceMeta5.setName("Devices");

    ServiceMeta serviceMeta6 = new ServiceMeta();
    serviceMeta6.setId((long) 6);
    serviceMeta6.setName("Blobs");

    ServiceMeta serviceMeta7 = new ServiceMeta();
    serviceMeta7.setId((long) 7);
    serviceMeta7.setName("Search");

    ServiceMeta serviceMeta8 = new ServiceMeta();
    serviceMeta8.setId((long) 8);
    serviceMeta8.setName("ImageStore");

    ServiceMeta serviceMeta9 = new ServiceMeta();
    serviceMeta9.setId((long) 9);
    serviceMeta9.setName("ExStore");

    ServiceMeta serviceMeta10 = new ServiceMeta();
    serviceMeta10.setId((long) 10);
    serviceMeta10.setName("Core");

    ServiceMeta serviceMeta11 = new ServiceMeta();
    serviceMeta11.setId((long) 11);
    serviceMeta11.setName("Activity");

    ServiceMeta serviceMeta12 = new ServiceMeta();
    serviceMeta12.setId((long) 12);
    serviceMeta12.setName("NotificationService");

    ServiceMeta serviceMeta13 = new ServiceMeta();
    serviceMeta13.setId((long) 13);
    serviceMeta13.setName("EmailService");

    ServiceMeta serviceMeta14 = new ServiceMeta();
    serviceMeta14.setId((long) 14);
    serviceMeta14.setName("Sources");

    ServiceMeta serviceMeta15 = new ServiceMeta();
    serviceMeta15.setId((long) 15);
    serviceMeta15.setName("ContentAI");

    addServiceMeta(serviceMeta1);
    addServiceMeta(serviceMeta2);
    addServiceMeta(serviceMeta3);
    addServiceMeta(serviceMeta4);
    addServiceMeta(serviceMeta5);
    addServiceMeta(serviceMeta6);
    addServiceMeta(serviceMeta7);
    addServiceMeta(serviceMeta8);
    addServiceMeta(serviceMeta9);
    addServiceMeta(serviceMeta10);
    addServiceMeta(serviceMeta11);
    addServiceMeta(serviceMeta12);
    addServiceMeta(serviceMeta13);
    addServiceMeta(serviceMeta14);
    addServiceMeta(serviceMeta15);
  }
}
