/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.impl.store;

import com.google.inject.Inject;
import org.appops.core.job.JobMeta;
import org.appops.core.job.token.JobToken;
import org.appops.core.job.token.JobTokenSet;
import org.appops.core.mime.MimeType;
import org.appops.core.service.OpParameterMap;
import org.appops.log.service.slim.service.Level;
import org.appops.logging.impl.LogManager;
import org.appops.logging.logger.Logger;
import org.appops.marshaller.DescriptorType;
import org.appops.marshaller.Marshaller;
import org.appops.service.crypto.ContentCrypto;
import org.appops.service.exception.InvocationException;
import org.appops.service.impl.ServiceStoreException;
import org.appops.service.job.TokenRouter;
import org.appops.service.store.JobMetaRegistry;
import org.appops.web.common.client.ServerResponse;
import org.appops.web.common.client.WebClient;

public class TokenRouterImpl
implements TokenRouter {
    private JobMetaRegistry jobMetaRegistry;
    private WebClient<?> webClient;
    private Marshaller marshaller;
    private Logger logger;

    public TokenRouterImpl() {
    }

    @Inject
    public TokenRouterImpl(LogManager logManager) {
        this.logger = logManager.getRootLogger();
    }

    public void routeJobToken(JobToken token) {
        if (token != null) {
            JobMeta jobMeta = this.getJobMetaRegistry().getJobMeta(token.getJobKey());
            String restUrl = null;
            if (jobMeta != null) {
                token.setJobAffinity(jobMeta.getAffinity());
                restUrl = jobMeta.getJobExecServiceAddress();
            }
            String opParamJson = this.populateOpParamMapJson(token);
            ServerResponse serverResponse = this.getWebClient().post(restUrl, (Object)opParamJson, MimeType.JSON);
            if (serverResponse.getStatus() != 200) {
                this.logger.withLevel(Level.SEVERE).withMessage("Rest invocation failed :" + restUrl).withMeta("ErrorCode", (Object)serverResponse.getStatus()).log();
                throw new InvocationException("Rest invocation failed, url -> " + restUrl + ", error code -> " + serverResponse.getStatus());
            }
        }
    }

    public void routeJobTokens(JobTokenSet tokens) {
        for (JobToken token : tokens) {
            try {
                this.routeJobToken(token);
            }
            catch (Exception e) {
                throw new ServiceStoreException(e);
            }
        }
    }

    private String populateOpParamMapJson(JobToken token) {
        String tokenJson = this.getMarshaller().marshall((Object)token, DescriptorType.JSON);
        tokenJson = new ContentCrypto().encrypt(tokenJson);
        OpParameterMap map = new OpParameterMap();
        map.addParameter(Integer.valueOf(0), "token", (Object)tokenJson);
        return this.getMarshaller().marshall((Object)map, DescriptorType.JSON);
    }

    public JobMetaRegistry getJobMetaRegistry() {
        return this.jobMetaRegistry;
    }

    @Inject
    public void setJobMetaRegistry(JobMetaRegistry jobMetaRegistry) {
        this.jobMetaRegistry = jobMetaRegistry;
    }

    public WebClient<?> getWebClient() {
        return this.webClient;
    }

    @Inject
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Inject
    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

