/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.impl.store;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.Parameter;
import org.appops.core.service.ServiceRoute;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.log.service.slim.service.Level;
import org.appops.logging.logger.Logger;
import org.appops.service.impl.ServiceStoreException;
import org.appops.service.store.ServiceMetaRegistry;
import org.appops.slim.base.api.ServiceMetaManager;
import org.appops.slim.base.core.ServiceStore;

public class ServiceMetaManagerImpl
implements ServiceMetaManager {
    private ServiceMetaRegistry serviceMetaRegistry;
    private Logger logger;

    @Inject
    public ServiceMetaManagerImpl(ServiceMetaRegistry serviceMetaRegistry) {
        this.serviceMetaRegistry = serviceMetaRegistry;
    }

    public void registerServiceMeta(ServiceMeta serviceMeta) {
        this.serviceMetaRegistry.addServiceMeta(serviceMeta);
    }

    public ServiceMeta getServiceMeta(String name) {
        ServiceMeta meta = this.getServiceMetaRegistry().getServiceMeta(name);
        return meta;
    }

    public ServiceRoute getServiceRoute(String name) {
        ServiceMeta meta = this.getServiceMetaRegistry().getServiceMeta(name);
        return meta.getRoute();
    }

    public ServiceOpMeta getOpMeta(String path) {
        return this.getServiceMetaRegistry().getOpMeta(path);
    }

    public ServiceOpMeta getOpMeta(String service, String path) {
        return this.getServiceMetaRegistry().getOpMeta(service, path);
    }

    public ServiceOpMeta getOpMeta(Long id) {
        return this.getServiceMetaRegistry().getOpMetaById(id);
    }

    public ServiceMetaRegistry getServiceMetaRegistry() {
        return this.serviceMetaRegistry;
    }

    public Collection<ServiceMeta> readAllServices() {
        if (this.isLogServiceStarted()) {
            this.saveOpLog(ServiceStore.class.getSimpleName(), "readAllServices");
        }
        return this.getServiceMetaRegistry().getAllServiceMetas();
    }

    private boolean isLogServiceStarted() {
        ServiceMeta serviceMeta;
        boolean isLogServiceExists = false;
        Collection serviceMetas = this.getServiceMetaRegistry().getAllServiceMetas();
        Iterator iterator = serviceMetas.iterator();
        while (iterator.hasNext() && !(isLogServiceExists = (serviceMeta = (ServiceMeta)iterator.next()).getName().equals("LogService"))) {
        }
        return isLogServiceExists;
    }

    public Collection<ServiceMeta> getServicesByPage(Integer startIndex, Integer pageSize) {
        if (this.isLogServiceStarted()) {
            this.saveOpLog(ServiceStore.class.getSimpleName(), "getServicesByPage");
        }
        return this.getServiceMetaRegistry().getServicesByPage(startIndex, pageSize);
    }

    public Collection<InterfaceMeta> getServiceInterfaces(String serviceName) {
        if (this.isLogServiceStarted()) {
            this.saveOpLog(ServiceStore.class.getSimpleName(), "getServiceInterfaces");
        }
        return this.getServiceMetaRegistry().getInterfaces(serviceName);
    }

    public Collection<ServiceOpMeta> getOperations(String serviceName, String interfaceName) {
        return this.getServiceMetaRegistry().getOperations(serviceName, interfaceName);
    }

    public Collection<ServiceMeta> getFilteredServices(String filter) {
        try {
            return this.filterServices(filter, this.readAllServices(), true);
        }
        catch (Exception e) {
            throw new ServiceStoreException("Failed to filter services using keyword(s) ->" + filter);
        }
    }

    public ArrayList<Parameter> getOperationParameters(String serviceName, String interfaceName, String operationName) {
        return this.getServiceMetaRegistry().getParameters(serviceName, interfaceName, operationName);
    }

    private Collection<ServiceMeta> filterServices(String filter, Collection<ServiceMeta> services, boolean deepFilter) {
        HashSet<ServiceMeta> listToReturn = new HashSet<ServiceMeta>();
        for (ServiceMeta service : services) {
            if (!service.getName().contains(filter)) continue;
            ServiceMeta filteredCopy = service.lightweightCopy();
            if (deepFilter) {
                filteredCopy.addInterfaces(this.filterInterfaces(filter, service.getInterfaces(), deepFilter));
            }
            listToReturn.add(filteredCopy);
        }
        return listToReturn;
    }

    private Collection<InterfaceMeta> filterInterfaces(String filter, Collection<InterfaceMeta> interfaces, boolean deepFilter) {
        HashSet<InterfaceMeta> listToReturn = new HashSet<InterfaceMeta>();
        for (InterfaceMeta interf : interfaces) {
            if (!interf.getName().contains(filter)) continue;
            InterfaceMeta filteredCopy = interf.lightweightCopy();
            if (deepFilter) {
                filteredCopy.addOperations(this.filterOperations(filter, interf.getOperations(), deepFilter));
            }
            listToReturn.add(filteredCopy);
        }
        return listToReturn;
    }

    private Collection<ServiceOpMeta> filterOperations(String filter, Set<ServiceOpMeta> operations, boolean deepFilter) {
        HashSet<ServiceOpMeta> operationList = new HashSet<ServiceOpMeta>();
        for (ServiceOpMeta operation : operations) {
            if (!operation.getName().contains(filter)) continue;
            ServiceOpMeta filteredCopy = operation.lightweightCopy();
            if (deepFilter) {
                filteredCopy.setParameters(this.filterParameters(filter, operation.getParameterSet()));
            }
            operationList.add(filteredCopy);
        }
        return operationList;
    }

    private OpParameterMap filterParameters(String filter, Set<Parameter> parameterSet) {
        OpParameterMap parameterMap = new OpParameterMap();
        for (Parameter parameter : parameterSet) {
            if (!parameter.getName().contains(filter)) continue;
            parameterMap.addParameter(parameter);
        }
        return parameterMap;
    }

    private void saveOpLog(String serviceName, String opName) {
        String logMessage = "Service operation log :  Service_Name -> " + serviceName + ", OperationName -> " + opName + " , Detailed message :- Started operation execution";
        this.logger.withLevel(Level.INFO).withMessage(logMessage).log();
    }

    public Logger getRootLogger() {
        return this.logger;
    }

    @Inject
    public void setRootLogger(Logger rootLogger) {
        this.logger = rootLogger;
    }
}

