/*
 * Decompiled with CFR 0.152.
 */
package org.appops.service.impl.store;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.appops.core.service.ExecutionMode;
import org.appops.core.service.OpParameterMap;
import org.appops.core.service.OpPathMatcher;
import org.appops.core.service.Parameter;
import org.appops.core.service.meta.InterfaceMeta;
import org.appops.core.service.meta.ServiceMeta;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;
import org.appops.service.impl.ServiceStoreException;
import org.appops.service.store.ServiceMetaRegistry;

public class ServiceMetaRegistryImpl
implements ServiceMetaRegistry {
    private Table<String, ExecutionMode, ServiceMeta> serviceMetaTable = HashBasedTable.create();
    private ServiceOpSignatureBuilder signatureBuilder;
    private static Long serviceId = 0L;

    public ServiceMeta getServiceMeta(String name) {
        if (!this.isServiceExists(name)) {
            throw new ServiceStoreException("Service with name -> " + name + " does not exist.");
        }
        ServiceMeta serviceMeta = (ServiceMeta)this.serviceMetaTable.get((Object)name, (Object)ExecutionMode.SERVICE);
        if (serviceMeta != null) {
            return serviceMeta;
        }
        return (ServiceMeta)this.serviceMetaTable.get((Object)name, (Object)ExecutionMode.JOB);
    }

    public boolean isServiceExists(String name) {
        if (name == null || name.isEmpty()) {
            throw new ServiceStoreException("Null or empty service name passed with service meta");
        }
        return this.serviceMetaTable.containsRow((Object)name);
    }

    public InterfaceMeta getInterfaceMeta(String service, String name) {
        if (name == null || name.isEmpty()) {
            throw new ServiceStoreException("Null or empty interface name passed, cannot add interfaceMeta.");
        }
        for (InterfaceMeta intrfcMeta : this.getServiceMeta(service).getInterfaces()) {
            if (!intrfcMeta.getName().equals(name)) continue;
            return intrfcMeta;
        }
        throw new ServiceStoreException("Interface with name -> " + name + " does not exist under service ->" + service);
    }

    public ServiceOpMeta getOpMeta(String pathOrSignature) {
        if (pathOrSignature == null) {
            throw new ServiceStoreException("Null Path / Signature passed, cannot find service op meta");
        }
        for (ServiceMeta serviceMeta : this.serviceMetaTable.values()) {
            for (InterfaceMeta intrfcMeta : serviceMeta.getInterfaces()) {
                for (ServiceOpMeta opMeta : intrfcMeta.getOperations()) {
                    if (!this.matchPath(opMeta.getPath(), pathOrSignature) && !this.matchSign(opMeta, pathOrSignature)) continue;
                    return opMeta;
                }
            }
        }
        throw new ServiceStoreException("Operation with path/signature -> " + pathOrSignature + " does not exist.");
    }

    public ServiceOpMeta getOpMeta(String service, String pathOrSignature) {
        if (pathOrSignature == null) {
            throw new ServiceStoreException("Null Path / Signature passed, cannot find service op meta");
        }
        for (ServiceMeta serviceMeta : this.serviceMetaTable.values()) {
            if (!serviceMeta.getName().equals(service)) continue;
            for (InterfaceMeta intrfcMeta : serviceMeta.getInterfaces()) {
                for (ServiceOpMeta opMeta : intrfcMeta.getOperations()) {
                    if (!this.matchPath(opMeta.getPath(), pathOrSignature) && !this.matchSign(opMeta, pathOrSignature)) continue;
                    return opMeta;
                }
            }
        }
        throw new ServiceStoreException("Operation with path/signature -> " + pathOrSignature + " does not exist.");
    }

    private boolean matchSign(ServiceOpMeta opMeta, String expectedSign) {
        String opSign = this.getSignatureBuilder().buildOpSignature(opMeta);
        return expectedSign != null && opSign != null && opSign.equals(expectedSign);
    }

    private boolean matchPath(String opPath, String requestPath) {
        return new OpPathMatcher().matchPath(opPath, requestPath);
    }

    public ServiceOpMeta getOpMetaById(Long id) {
        if (id == null) {
            throw new ServiceStoreException("Null id passed, cannot find service op meta");
        }
        for (ServiceMeta serviceMeta : this.serviceMetaTable.values()) {
            for (InterfaceMeta intrfcMeta : serviceMeta.getInterfaces()) {
                for (ServiceOpMeta opMeta : intrfcMeta.getOperations()) {
                    if (opMeta.getId() != id) continue;
                    return opMeta;
                }
            }
        }
        throw new ServiceStoreException("Operation with id -> " + id + " does not exist.");
    }

    public void addServiceMeta(ServiceMeta serviceMeta) {
        if (serviceMeta == null) {
            throw new ServiceStoreException("Cannot store null service meta");
        }
        if (this.isServiceExists(serviceMeta.getName())) {
            return;
        }
        serviceId = serviceId + 1L;
        serviceMeta.setId(serviceId);
        ExecutionMode executionMode = serviceMeta.getExecutionMode() == null ? ExecutionMode.SERVICE : serviceMeta.getExecutionMode();
        this.serviceMetaTable.put((Object)serviceMeta.getName(), (Object)executionMode, (Object)serviceMeta);
    }

    public void addInterfaceMeta(String service, InterfaceMeta intrfcMeta) {
        if (intrfcMeta == null) {
            throw new ServiceStoreException("Cannot store null interface meta under service -> " + service);
        }
        this.getServiceMeta(service).addInterface(intrfcMeta);
    }

    public void addOpMeta(String service, String intrfc, ServiceOpMeta opMeta) {
        if (opMeta == null) {
            throw new ServiceStoreException("Cannot store null service op meta under service -> " + service);
        }
        this.getInterfaceMeta(service, intrfc).addOperation(opMeta);
    }

    public ServiceOpSignatureBuilder getSignatureBuilder() {
        return this.signatureBuilder;
    }

    @Inject
    public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
        this.signatureBuilder = signatureBuilder;
    }

    public Collection<ServiceMeta> getAllServiceMetas() {
        return this.serviceMetaTable.values();
    }

    public Collection<ServiceMeta> getServicesByPage(Integer startIndex, Integer pageSize) {
        try {
            ArrayList<ServiceMeta> listToReturn = new ArrayList<ServiceMeta>();
            int endIndex = startIndex + pageSize;
            Collection<ServiceMeta> mockData = this.getAllServiceMetas();
            for (ServiceMeta element : mockData) {
                if (element.getId() < (long)startIndex.intValue() || element.getId() > (long)endIndex || mockData.size() == startIndex.intValue()) continue;
                listToReturn.add(element);
            }
            return listToReturn;
        }
        catch (NullPointerException e) {
            throw new ServiceStoreException(e.getMessage());
        }
    }

    public Collection<InterfaceMeta> getInterfaces(String serviceName) {
        return this.getServiceMeta(serviceName).getInterfaces();
    }

    public Collection<ServiceOpMeta> getOperations(String serviceName, String interfaceName) {
        HashSet<ServiceOpMeta> opMetas = new HashSet<ServiceOpMeta>();
        for (InterfaceMeta interfaceMeta : this.getInterfaces(serviceName)) {
            if (!interfaceMeta.getName().equals(interfaceName)) continue;
            opMetas.addAll(interfaceMeta.getOperations());
            break;
        }
        return opMetas;
    }

    public ArrayList<Parameter> getParameters(String serviceName, String interfaceName, String operationName) {
        OpParameterMap opParams = new OpParameterMap();
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        Collection<InterfaceMeta> interfaceMetaSet = this.getInterfaces(serviceName);
        block0: for (InterfaceMeta interfaceMeta : interfaceMetaSet) {
            if (!interfaceMeta.getName().equals(interfaceName)) continue;
            Set serviceOpmetaSet = interfaceMeta.getOperations();
            for (ServiceOpMeta opMeta : serviceOpmetaSet) {
                if (!opMeta.getName().equals(operationName)) continue;
                OpParameterMap opMap = opMeta.getParameters();
                for (Map.Entry entry : opMap.entrySet()) {
                    paramList.add((Parameter)entry.getValue());
                }
                continue block0;
            }
        }
        return paramList;
    }
}

