/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */
package org.appops.slim.base.invocation.async;

import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;
import org.asynchttpclient.Response;

/**
 * Api Proxy invocation handler class which takes care of service api call made using proxy.
 *
 */
public class AsyncApiProxyInvocationHandler implements InvocationHandler {

  private AsyncApiRestInvoker apiRestAsyncInvoker;
  private ServiceOpSignatureBuilder signatureBuilder;

  @Override
  public CompletableFuture<Response> invoke(Object proxy, Method method, Object[] args)
      throws Throwable {
    ServiceOpMeta opMeta = createOpMeta(method, args);
    return getApiRestAsyncInvoker().invokeRest(opMeta);
  }


  /**
   * Creates service operation meta instance from method and arguments provided.
   * 
   * @param method method definition from which meta information is to be collected.
   * @param args Argument values passed to method while invocation.
   * @return operation meta instance generated.
   * @throws NoSuchMethodException Thrown when particular method not found.
   * @throws SecurityException Thrown by the security manager to indicate security violation.
   */
  public ServiceOpMeta createOpMeta(Method method, Object[] args)
      throws NoSuchMethodException, SecurityException {

    AsyncOpMetaComputer compute = new AsyncOpMetaComputer();
    return compute.computeOpMeta(method, args);
  }

  public AsyncApiRestInvoker getApiRestAsyncInvoker() {
    return apiRestAsyncInvoker;
  }

  @Inject
  public void setApiRestAsyncInvoker(AsyncApiRestInvoker apiRestInvoker) {
    this.apiRestAsyncInvoker = apiRestInvoker;
  }

  public ServiceOpSignatureBuilder getSignatureBuilder() {
    return signatureBuilder;
  }

  @Inject
  public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
    this.signatureBuilder = signatureBuilder;
  }
}
