/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.web.common.client;

/**
 * <p>Cookie class.</p>
 *
 * @author deba
 * @version $Id: $Id
 */
public class Cookie {

  private String name;
  private String value;
  private String domain;
  private long maxAge = -1;
  private String path = "";
  private boolean secure;
  private int version = 1;
  private boolean httpOnly;

  /**
   * <p>Constructor for Cookie.</p>
   *
   * @param name a {@link java.lang.String} object.
   * @param value a {@link java.lang.String} object.
   */
  public Cookie(String name, String value) {
    setName(name);
    setValue(value);
  }

  /**
   * <p>name.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String name() {
    return name;
  }

  /**
   * <p>Setter for the field <code>name</code>.</p>
   *
   * @param name a {@link java.lang.String} object.
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * <p>value.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String value() {
    return value;
  }

  /**
   * <p>Setter for the field <code>value</code>.</p>
   *
   * @param value a {@link java.lang.String} object.
   */
  public void setValue(String value) {
    this.value = value;
  }

  /**
   * <p>domain.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String domain() {
    return domain;
  }

  /**
   * <p>Setter for the field <code>domain</code>.</p>
   *
   * @param domain a {@link java.lang.String} object.
   */
  public void setDomain(String domain) {
    this.domain = domain;
  }

  /**
   * <p>maxAge.</p>
   *
   * @return a long.
   */
  public long maxAge() {
    return maxAge;
  }

  /**
   * <p>Setter for the field <code>maxAge</code>.</p>
   *
   * @param maxAge a long.
   */
  public void setMaxAge(long maxAge) {
    this.maxAge = maxAge;
  }

  /**
   * <p>path.</p>
   *
   * @return a {@link java.lang.String} object.
   */
  public String path() {
    return path;
  }

  /**
   * <p>Setter for the field <code>path</code>.</p>
   *
   * @param path a {@link java.lang.String} object.
   */
  public void setPath(String path) {
    this.path = path;
  }

  /**
   * <p>isSecure.</p>
   *
   * @return a boolean.
   */
  public boolean isSecure() {
    return secure;
  }

  /**
   * <p>Setter for the field <code>secure</code>.</p>
   *
   * @param secure a boolean.
   */
  public void setSecure(boolean secure) {
    this.secure = secure;
  }

  /**
   * <p>version.</p>
   *
   * @return a int.
   */
  public int version() {
    return version;
  }

  /**
   * <p>Setter for the field <code>version</code>.</p>
   *
   * @param version a int.
   */
  public void setVersion(int version) {
    this.version = version;
  }

  /**
   * <p>isHttpOnly.</p>
   *
   * @return a boolean.
   */
  public boolean isHttpOnly() {
    return httpOnly;
  }

  /**
   * <p>Setter for the field <code>httpOnly</code>.</p>
   *
   * @param httpOnly a boolean.
   */
  public void setHttpOnly(boolean httpOnly) {
    this.httpOnly = httpOnly;
  }
}
