/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.web.common.server;

import java.net.URL;
import org.appops.core.deployment.JettyConfig;

/**
 * Wrapper base class which wraps actual web server.
 *
 * @author deba
 * @version $Id: $Id
 */
public abstract class WebServer<S> {

  private int port;
  private S wrappedServer;


  /**
   * <p>
   * Constructor for WebServer.
   * </p>
   *
   * @param port a int.
   * @param wrappedServer a S object.
   */
  protected WebServer(int port, S wrappedServer) {
    this.port = port;
    this.wrappedServer = wrappedServer;
  }


  /**
   * Connects web server.
   *
   * @return Updated wrapper after connecting server.
   */
  public abstract WebServer<S> connect();

  /**
   * Disconnects already connected web server.
   */
  public abstract void disconnect();

  /**
   * Checks if server is currently connected or not.
   *
   * @return true if connected, false otherwise.
   */
  public abstract boolean isConnected();


  /**
   * Configures serve context e.g. context path, war file path etc.
   *
   * @param contextPath Context path to be set to server.
   * @param webappDirOrWarPath Can be a path to web app directory or a war file.
   * @param serviceName service name
   * @param jettyConfig database configuration for jetty session
   */
  public abstract void configureAppContext(String contextPath, URL webappDirOrWarPath,
      String serviceName, JettyConfig jettyConfig);

  /**
   * Fetches actual wrapped web server (e.g. Jetty).
   *
   * @return wrapped web server instance
   */
  public S wrappedServer() {
    return wrappedServer;
  }


  /**
   * <p>
   * Getter for the field <code>port</code>.
   * </p>
   *
   * @return a int.
   */
  public int getPort() {
    return port;
  }
}
