/*
 * AppOps is a Java framework to develop, deploy microservices with ease and is available for free
 * and common use developed by AinoSoft ( www.ainosoft.com )
 *
 * AppOps and AinoSoft are registered trademarks of Aino Softwares private limited, India.
 *
 * Copyright (C) <2016> <Aino Softwares private limited>
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version along with applicable additional terms as
 * provisioned by GPL 3.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License and applicable additional terms
 * along with this program.
 *
 * If not, see <https://www.gnu.org/licenses/> and <https://www.appops.org/license>
 */

package org.appops.slim.base.invocation;

import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.appops.core.service.meta.ServiceOpMeta;
import org.appops.core.service.signature.ServiceOpSignatureBuilder;

/**
 * Proxy invocation handler class which takes care of service api call made using proxy.
 *
 * @author deba
 * @version $Id: $Id
 */
public class ApiProxyInvocationHandler implements InvocationHandler {

  private ApiRestInvoker apiRestInvoker;
  private ServiceOpSignatureBuilder signatureBuilder;


  /** {@inheritDoc} */
  @Override
  public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
    ServiceOpMeta opMeta = createOpMeta(method, args);
    return getApiRestInvoker().invokeRest(opMeta);
  }


  /**
   * Creates service operation meta instance from method and arguments provided.
   *
   * @param method method definition from which meta information is to be collected.
   * @param args Argument values passed to method while invocation.
   * @return operation meta instance generated.
   */
  public ServiceOpMeta createOpMeta(Method method, Object[] args) {

    OpMetaComputer compute = new OpMetaComputer();
    return compute.computeOpMeta(method, args);
  }


  /**
   * <p>
   * Getter for the field <code>apiRestInvoker</code>.
   * </p>
   *
   * @return a {@link org.appops.slim.base.invocation.ApiRestInvoker} object.
   */
  public ApiRestInvoker getApiRestInvoker() {
    return apiRestInvoker;
  }


  /**
   * <p>
   * Setter for the field <code>apiRestInvoker</code>.
   * </p>
   *
   * @param apiRestInvoker a {@link org.appops.slim.base.invocation.ApiRestInvoker} object.
   */
  @Inject
  public void setApiRestInvoker(ApiRestInvoker apiRestInvoker) {
    this.apiRestInvoker = apiRestInvoker;
  }


  /**
   * <p>
   * Getter for the field <code>signatureBuilder</code>.
   * </p>
   *
   * @return a {@link org.appops.core.service.signature.ServiceOpSignatureBuilder} object.
   */
  public ServiceOpSignatureBuilder getSignatureBuilder() {
    return signatureBuilder;
  }


  /**
   * <p>
   * Setter for the field <code>signatureBuilder</code>.
   * </p>
   *
   * @param signatureBuilder a {@link org.appops.core.service.signature.ServiceOpSignatureBuilder}
   *        object.
   */
  @Inject
  public void setSignatureBuilder(ServiceOpSignatureBuilder signatureBuilder) {
    this.signatureBuilder = signatureBuilder;
  }

}
